/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.client.impl;

import java.io.InputStream;
import java.net.URI;
import java.util.Date;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.client.ClientResponseContext;
import javax.ws.rs.core.EntityTag;
import javax.ws.rs.core.Link;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.NewCookie;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.client.impl.RestClientRequestContext;
import org.jboss.resteasy.reactive.common.headers.HeaderUtil;
import org.jboss.resteasy.reactive.common.headers.LinkHeaders;
import org.jboss.resteasy.reactive.common.jaxrs.StatusTypeImpl;

public class ClientResponseContextImpl
implements ClientResponseContext {
    private final RestClientRequestContext state;

    public ClientResponseContextImpl(RestClientRequestContext state) {
        this.state = state;
    }

    public String getReasonPhrase() {
        return this.state.getResponseReasonPhrase();
    }

    public ClientResponseContextImpl setReasonPhrase(String reasonPhrase) {
        this.state.setResponseReasonPhrase(reasonPhrase);
        return this;
    }

    public ClientResponseContextImpl setHeaders(MultivaluedMap<String, String> headers) {
        this.state.setResponseHeaders(headers);
        return this;
    }

    public int getStatus() {
        return this.state.getResponseStatus();
    }

    public void setStatus(int code) {
        this.state.setResponseStatus(code);
    }

    public Response.StatusType getStatusInfo() {
        return new StatusTypeImpl(this.state.getResponseStatus(), this.state.getResponseReasonPhrase());
    }

    public void setStatusInfo(Response.StatusType statusInfo) {
        this.state.setResponseStatus(statusInfo.getStatusCode()).setResponseReasonPhrase(statusInfo.getReasonPhrase());
    }

    public MultivaluedMap<String, String> getHeaders() {
        return this.state.getResponseHeaders();
    }

    public String getHeaderString(String name) {
        return HeaderUtil.getHeaderString(this.state.getResponseHeaders(), (String)name);
    }

    public Set<String> getAllowedMethods() {
        return HeaderUtil.getAllowedMethods(this.state.getResponseHeaders());
    }

    public Date getDate() {
        return HeaderUtil.getDate(this.state.getResponseHeaders());
    }

    public Locale getLanguage() {
        return HeaderUtil.getLanguage(this.state.getResponseHeaders());
    }

    public int getLength() {
        return HeaderUtil.getLength(this.state.getResponseHeaders());
    }

    public MediaType getMediaType() {
        return HeaderUtil.getMediaType(this.state.getResponseHeaders());
    }

    public Map<String, NewCookie> getCookies() {
        return HeaderUtil.getNewCookies(this.state.getResponseHeaders());
    }

    public EntityTag getEntityTag() {
        return HeaderUtil.getEntityTag(this.state.getResponseHeaders());
    }

    public Date getLastModified() {
        return HeaderUtil.getLastModified(this.state.getResponseHeaders());
    }

    public URI getLocation() {
        return HeaderUtil.getLocation(this.state.getResponseHeaders());
    }

    private LinkHeaders getLinkHeaders() {
        return new LinkHeaders(this.state.getResponseHeaders());
    }

    public Set<Link> getLinks() {
        return new HashSet<Link>(this.getLinkHeaders().getLinks());
    }

    public boolean hasLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation) != null;
    }

    public Link getLink(String relation) {
        return this.getLinkHeaders().getLinkByRelationship(relation);
    }

    public Link.Builder getLinkBuilder(String relation) {
        Link link = this.getLinkHeaders().getLinkByRelationship(relation);
        if (link == null) {
            return null;
        }
        return Link.fromLink((Link)link);
    }

    public boolean hasEntity() {
        return this.state.getResponseEntityStream() != null;
    }

    public InputStream getEntityStream() {
        return this.state.getResponseEntityStream();
    }

    public void setEntityStream(InputStream input) {
        this.state.setResponseEntityStream(input);
    }
}

