/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.vertx.providers.serialisers.json;

import io.vertx.core.MultiMap;
import java.util.Map;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.reactive.server.spi.ServerRequestContext;

public final class JsonMessageBodyWriterUtil {
    private JsonMessageBodyWriterUtil() {
    }

    public static void setContentTypeIfNecessary(MultivaluedMap<String, Object> httpHeaders) {
        Object contentType = httpHeaders.getFirst((Object)"Content-Type");
        if (JsonMessageBodyWriterUtil.isNotJson(contentType)) {
            httpHeaders.putSingle((Object)"Content-Type", (Object)"application/json");
        }
    }

    public static void setContentTypeIfNecessary(ServerRequestContext context) {
        String currentContentType = null;
        Iterable responseHeaders = context.serverResponse().getAllResponseHeaders();
        if (responseHeaders instanceof MultiMap) {
            currentContentType = ((MultiMap)responseHeaders).get("Content-Type");
        } else {
            for (Map.Entry entry : responseHeaders) {
                if (!((String)entry.getKey()).equalsIgnoreCase("Content-Type")) continue;
                currentContentType = (String)entry.getValue();
                break;
            }
        }
        if (JsonMessageBodyWriterUtil.isNotJson(currentContentType)) {
            context.serverResponse().setResponseHeader((CharSequence)"Content-Type", (CharSequence)"application/json");
        }
    }

    private static boolean isNotJson(Object contentType) {
        return contentType == null || !contentType.toString().contains("json");
    }
}

