/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.spi;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Set;
import javax.ws.rs.container.ResourceInfo;

public class ResteasyReactiveResourceInfo
implements ResourceInfo {
    private static final String JSON_VIEW_NAME = "com.fasterxml.jackson.annotation.JsonView";
    private static final String CUSTOM_SERIALIZATION = "io.quarkus.resteasy.reactive.jackson.CustomSerialization";
    private final String name;
    private final Class<?> declaringClass;
    private final Class[] parameterTypes;
    private final Set<String> classAnnotationNames;
    private final Set<String> methodAnnotationNames;
    private final boolean requiresCustomSerialization;
    private final boolean requiresJsonViewName;
    private volatile Annotation[] classAnnotations;
    private volatile Method method;
    private volatile Annotation[] annotations;
    private volatile Type returnType;

    public ResteasyReactiveResourceInfo(String name, Class<?> declaringClass, Class[] parameterTypes, Set<String> classAnnotationNames, Set<String> methodAnnotationNames) {
        this.name = name;
        this.declaringClass = declaringClass;
        this.parameterTypes = parameterTypes;
        this.classAnnotationNames = classAnnotationNames;
        this.methodAnnotationNames = methodAnnotationNames;
        this.requiresCustomSerialization = methodAnnotationNames.contains(CUSTOM_SERIALIZATION);
        this.requiresJsonViewName = methodAnnotationNames.contains(JSON_VIEW_NAME);
    }

    public String getName() {
        return this.name;
    }

    public Class[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Set<String> getClassAnnotationNames() {
        return this.classAnnotationNames;
    }

    public Set<String> getMethodAnnotationNames() {
        return this.methodAnnotationNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getMethod() {
        if (this.method == null) {
            ResteasyReactiveResourceInfo resteasyReactiveResourceInfo = this;
            synchronized (resteasyReactiveResourceInfo) {
                if (this.method == null) {
                    try {
                        Method declaredMethod = this.declaringClass.getMethod(this.name, this.parameterTypes);
                        this.annotations = declaredMethod.getAnnotations();
                        this.returnType = declaredMethod.getGenericReturnType();
                        this.method = declaredMethod;
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
        return this.method;
    }

    public Annotation[] getClassAnnotations() {
        if (this.classAnnotations == null) {
            this.classAnnotations = this.declaringClass.getAnnotations();
        }
        return this.classAnnotations;
    }

    public Annotation[] getAnnotations() {
        if (this.annotations == null) {
            this.getMethod();
        }
        return this.annotations;
    }

    public Type getGenericReturnType() {
        if (this.returnType == null) {
            this.getMethod();
        }
        return this.returnType;
    }

    public Method getResourceMethod() {
        return this.getMethod();
    }

    public Class<?> getResourceClass() {
        return this.declaringClass;
    }

    public Annotation[] getParameterAnnotations(int index) {
        return this.getMethod().getParameterAnnotations()[index];
    }

    public boolean requiresCustomSerialization() {
        return this.requiresCustomSerialization;
    }

    public boolean requiresJsonViewName() {
        return this.requiresJsonViewName;
    }
}

