/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core;

import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.ws.rs.core.MediaType;
import org.jboss.resteasy.reactive.server.spi.ContentType;

public class EncodedMediaType
implements ContentType {
    final MediaType mediaType;
    final String charset;
    String encoded;

    public EncodedMediaType(MediaType mediaType) {
        String effectiveCharset;
        MediaType effectiveMediaType = mediaType;
        String originalCharset = (String)mediaType.getParameters().get("charset");
        if (this.isStringMediaType(mediaType)) {
            effectiveCharset = originalCharset;
            if (effectiveCharset == null) {
                effectiveCharset = StandardCharsets.UTF_8.name();
            }
        } else {
            effectiveCharset = null;
        }
        this.charset = effectiveCharset;
        if (!Objects.equals(originalCharset, effectiveCharset)) {
            effectiveMediaType = mediaType.withCharset(effectiveCharset);
        }
        this.mediaType = effectiveMediaType;
    }

    private boolean isStringMediaType(MediaType mediaType) {
        String type = mediaType.getType();
        String subtype = mediaType.getSubtype();
        return type.equals("application") && (subtype.contains("json") || subtype.contains("xml") || subtype.contains("yaml")) || type.equals("text");
    }

    public String toString() {
        return this.getEncoded();
    }

    @Override
    public MediaType getMediaType() {
        return this.mediaType;
    }

    @Override
    public String getEncoded() {
        if (this.encoded == null) {
            this.encoded = this.mediaType.toString();
            return this.encoded;
        }
        return this.encoded;
    }

    @Override
    public String getCharset() {
        return this.charset;
    }
}

