/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.core.startup;

import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.ws.rs.RuntimeType;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.core.Application;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import org.jboss.resteasy.reactive.common.jaxrs.ConfigurationImpl;
import org.jboss.resteasy.reactive.common.model.ResourceClass;
import org.jboss.resteasy.reactive.common.model.ResourceFeature;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptor;
import org.jboss.resteasy.reactive.common.model.ResourceInterceptors;
import org.jboss.resteasy.reactive.common.model.ResourceMethod;
import org.jboss.resteasy.reactive.common.util.DeploymentUtils;
import org.jboss.resteasy.reactive.server.core.Deployment;
import org.jboss.resteasy.reactive.server.core.DeploymentInfo;
import org.jboss.resteasy.reactive.server.core.ExceptionMapping;
import org.jboss.resteasy.reactive.server.core.RequestContextFactory;
import org.jboss.resteasy.reactive.server.core.ServerSerialisers;
import org.jboss.resteasy.reactive.server.core.serialization.DynamicEntityWriter;
import org.jboss.resteasy.reactive.server.core.startup.CustomServerRestHandlers;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeInterceptorDeployment;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeMappingDeployment;
import org.jboss.resteasy.reactive.server.core.startup.RuntimeResourceDeployment;
import org.jboss.resteasy.reactive.server.handlers.ClassRoutingHandler;
import org.jboss.resteasy.reactive.server.handlers.ExceptionHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceLocatorHandler;
import org.jboss.resteasy.reactive.server.handlers.ResourceRequestFilterHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseHandler;
import org.jboss.resteasy.reactive.server.handlers.ResponseWriterHandler;
import org.jboss.resteasy.reactive.server.handlers.RestInitialHandler;
import org.jboss.resteasy.reactive.server.jaxrs.FeatureContextImpl;
import org.jboss.resteasy.reactive.server.mapping.RequestMapper;
import org.jboss.resteasy.reactive.server.mapping.RuntimeResource;
import org.jboss.resteasy.reactive.server.mapping.URITemplate;
import org.jboss.resteasy.reactive.server.model.Features;
import org.jboss.resteasy.reactive.server.model.HandlerChainCustomizer;
import org.jboss.resteasy.reactive.server.model.ParamConverterProviders;
import org.jboss.resteasy.reactive.server.model.ServerResourceMethod;
import org.jboss.resteasy.reactive.server.spi.RuntimeConfigurableServerRestHandler;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;
import org.jboss.resteasy.reactive.spi.BeanFactory;
import org.jboss.resteasy.reactive.spi.ThreadSetupAction;

public class RuntimeDeploymentManager {
    public static final ServerRestHandler[] EMPTY_REST_HANDLER_ARRAY = new ServerRestHandler[0];
    private final DeploymentInfo info;
    private final Supplier<Executor> executorSupplier;
    private final CustomServerRestHandlers customServerRestHandlers;
    private final Consumer<Closeable> closeTaskHandler;
    private final RequestContextFactory requestContextFactory;
    private final ThreadSetupAction threadSetupAction;
    private final String rootPath;

    public RuntimeDeploymentManager(DeploymentInfo info, Supplier<Executor> executorSupplier, CustomServerRestHandlers customServerRestHandlers, Consumer<Closeable> closeTaskHandler, RequestContextFactory requestContextFactory, ThreadSetupAction threadSetupAction, String rootPath) {
        this.info = info;
        this.executorSupplier = executorSupplier;
        this.customServerRestHandlers = customServerRestHandlers;
        this.closeTaskHandler = closeTaskHandler;
        this.requestContextFactory = requestContextFactory;
        this.threadSetupAction = threadSetupAction;
        this.rootPath = rootPath;
    }

    /*
     * WARNING - void declaration
     */
    public Deployment deploy() {
        void var20_36;
        ResourceInterceptors interceptors = this.info.getInterceptors();
        ServerSerialisers serialisers = this.info.getSerialisers();
        Features features = this.info.getFeatures();
        ExceptionMapping exceptionMapping = this.info.getExceptionMapping();
        List<ResourceClass> resourceClasses = this.info.getResourceClasses();
        List<ResourceClass> locatableResourceClasses = this.info.getLocatableResourceClasses();
        ParamConverterProviders paramConverterProviders = this.info.getParamConverterProviders();
        Supplier<Application> applicationSupplier = this.info.getApplicationSupplier();
        String applicationPath = this.info.getApplicationPath();
        DynamicEntityWriter dynamicEntityWriter = new DynamicEntityWriter(serialisers);
        ConfigurationImpl configurationImpl = this.configureFeatures(features, interceptors, exceptionMapping);
        RuntimeInterceptorDeployment interceptorDeployment = new RuntimeInterceptorDeployment(this.info, configurationImpl, this.closeTaskHandler);
        ResourceLocatorHandler resourceLocatorHandler = new ResourceLocatorHandler(new Function<Class<?>, BeanFactory.BeanInstance<?>>(){

            @Override
            public BeanFactory.BeanInstance<?> apply(Class<?> aClass) {
                return RuntimeDeploymentManager.this.info.getFactoryCreator().apply(aClass).createInstance();
            }
        });
        ArrayList<RuntimeConfigurableServerRestHandler> runtimeConfigurableServerRestHandlers = new ArrayList<RuntimeConfigurableServerRestHandler>();
        RuntimeResourceDeployment runtimeResourceDeployment = new RuntimeResourceDeployment(this.info, this.executorSupplier, this.customServerRestHandlers, interceptorDeployment, dynamicEntityWriter, resourceLocatorHandler, this.requestContextFactory.isDefaultBlocking());
        ArrayList<ResourceClass> possibleSubResource = new ArrayList<ResourceClass>(locatableResourceClasses);
        possibleSubResource.addAll(resourceClasses);
        for (ResourceClass resourceClass : possibleSubResource) {
            HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> hashMap = new HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>();
            URITemplate uRITemplate = resourceClass.getPath() == null ? null : new URITemplate(resourceClass.getPath(), true);
            for (Object method : resourceClass.getMethods()) {
                RuntimeResource runtimeResource = runtimeResourceDeployment.buildResourceMethod(resourceClass, (ServerResourceMethod)((Object)method), true, uRITemplate, this.info);
                this.addRuntimeConfigurableHandlers(runtimeResource, runtimeConfigurableServerRestHandlers);
                RuntimeMappingDeployment.buildMethodMapper(hashMap, (ResourceMethod)method, runtimeResource);
            }
            Map<String, RequestMapper<RuntimeResource>> mappersByMethod = RuntimeMappingDeployment.buildClassMapper(hashMap);
            resourceLocatorHandler.addResource(DeploymentUtils.loadClass((String)resourceClass.getClassName()), mappersByMethod);
        }
        TreeMap<URITemplate, HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>> mappers = new TreeMap<URITemplate, HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>>();
        for (ResourceClass resourceClass : resourceClasses) {
            URITemplate uRITemplate = new URITemplate(resourceClass.getPath(), true);
            HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>> perClassMappers = (HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>)mappers.get(uRITemplate);
            if (perClassMappers == null) {
                perClassMappers = new HashMap<String, TreeMap<URITemplate, List<RequestMapper.RequestPath<RuntimeResource>>>>();
                mappers.put(uRITemplate, perClassMappers);
            }
            for (ResourceMethod method : resourceClass.getMethods()) {
                RuntimeResource runtimeResource = runtimeResourceDeployment.buildResourceMethod(resourceClass, (ServerResourceMethod)method, false, uRITemplate, this.info);
                this.addRuntimeConfigurableHandlers(runtimeResource, runtimeConfigurableServerRestHandlers);
                RuntimeMappingDeployment.buildMethodMapper(perClassMappers, method, runtimeResource);
            }
        }
        ArrayList<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>> arrayList = new ArrayList<RequestMapper.RequestPath<RestInitialHandler.InitialMatch>>();
        for (Map.Entry entry : mappers.entrySet()) {
            URITemplate classTemplate = (URITemplate)entry.getKey();
            int classTemplateNameCount = classTemplate.countPathParamNames();
            Map perClassMappers = (Map)entry.getValue();
            Map<String, RequestMapper<RuntimeResource>> mappersByMethod = RuntimeMappingDeployment.buildClassMapper(perClassMappers);
            ClassRoutingHandler classRoutingHandler = new ClassRoutingHandler(mappersByMethod, classTemplateNameCount);
            int maxMethodTemplateNameCount = 0;
            for (TreeMap i : perClassMappers.values()) {
                for (URITemplate j : i.keySet()) {
                    maxMethodTemplateNameCount = Math.max(maxMethodTemplateNameCount, j.countPathParamNames());
                }
            }
            arrayList.add(new RequestMapper.RequestPath<RestInitialHandler.InitialMatch>(true, classTemplate, new RestInitialHandler.InitialMatch(new ServerRestHandler[]{classRoutingHandler}, maxMethodTemplateNameCount + classTemplateNameCount)));
        }
        ArrayList<ServerRestHandler> arrayList2 = new ArrayList<ServerRestHandler>();
        if (interceptorDeployment.getGlobalInterceptorHandler() != null) {
            arrayList2.add(interceptorDeployment.getGlobalInterceptorHandler());
        }
        arrayList2.add(new ExceptionHandler());
        if (!interceptors.getContainerResponseFilters().getGlobalResourceInterceptors().isEmpty()) {
            arrayList2.addAll(interceptorDeployment.getGlobalResponseInterceptorHandlers());
        }
        arrayList2.add(new ResponseHandler());
        arrayList2.add(new ResponseWriterHandler(dynamicEntityWriter));
        String string = this.rootPath;
        if (string != null) {
            String string2 = this.sanitizePathPrefix(string);
        } else {
            String string3 = "";
        }
        if (applicationPath != null && !applicationPath.isEmpty()) {
            void var20_34;
            String string4 = (String)var20_34 + this.sanitizePathPrefix(applicationPath);
        }
        ArrayList<ServerRestHandler> preMatchHandlers = new ArrayList<ServerRestHandler>();
        for (int i = 0; i < this.info.getGlobalHandlerCustomizers().size(); ++i) {
            preMatchHandlers.addAll(this.info.getGlobalHandlerCustomizers().get(i).handlers(HandlerChainCustomizer.Phase.BEFORE_PRE_MATCH));
        }
        if (!interceptors.getContainerRequestFilters().getPreMatchInterceptors().isEmpty()) {
            preMatchHandlers = new ArrayList(interceptorDeployment.getPreMatchContainerRequestFilters().size());
            for (Map.Entry<ResourceInterceptor<ContainerRequestFilter>, ContainerRequestFilter> entry : interceptorDeployment.getPreMatchContainerRequestFilters().entrySet()) {
                preMatchHandlers.add(new ResourceRequestFilterHandler(entry.getValue(), true, entry.getKey().isNonBlockingRequired()));
            }
        }
        for (int i = 0; i < this.info.getGlobalHandlerCustomizers().size(); ++i) {
            preMatchHandlers.addAll(this.info.getGlobalHandlerCustomizers().get(i).handlers(HandlerChainCustomizer.Phase.AFTER_PRE_MATCH, null, null));
        }
        return new Deployment(exceptionMapping, this.info.getCtxResolvers(), serialisers, arrayList2.toArray(EMPTY_REST_HANDLER_ARRAY), dynamicEntityWriter, (String)var20_36, paramConverterProviders, configurationImpl, applicationSupplier, this.threadSetupAction, this.requestContextFactory, preMatchHandlers, arrayList, runtimeConfigurableServerRestHandlers);
    }

    private void addRuntimeConfigurableHandlers(RuntimeResource runtimeResource, List<RuntimeConfigurableServerRestHandler> runtimeConfigurableServerRestHandlers) {
        for (ServerRestHandler serverRestHandler : runtimeResource.getHandlerChain()) {
            if (!(serverRestHandler instanceof RuntimeConfigurableServerRestHandler)) continue;
            runtimeConfigurableServerRestHandlers.add((RuntimeConfigurableServerRestHandler)serverRestHandler);
        }
    }

    private ConfigurationImpl configureFeatures(Features features, ResourceInterceptors interceptors, ExceptionMapping exceptionMapping) {
        ConfigurationImpl configuration = new ConfigurationImpl(RuntimeType.SERVER);
        if (features.getResourceFeatures().isEmpty()) {
            return configuration;
        }
        FeatureContextImpl featureContext = new FeatureContextImpl(interceptors, exceptionMapping, configuration, this.info.getFactoryCreator());
        List<ResourceFeature> resourceFeatures = features.getResourceFeatures();
        for (ResourceFeature resourceFeature : resourceFeatures) {
            Feature feature = (Feature)resourceFeature.getFactory().createInstance().getInstance();
            boolean enabled = feature.configure((FeatureContext)featureContext);
            if (!enabled) continue;
            configuration.addEnabledFeature(feature);
        }
        if (featureContext.isFiltersNeedSorting()) {
            interceptors.sort();
        }
        return configuration;
    }

    private String sanitizePathPrefix(String prefix) {
        if (((String)(prefix = ((String)prefix).trim())).equals("/")) {
            prefix = "";
        }
        if (!((String)prefix).startsWith("/")) {
            prefix = "/" + (String)prefix;
        }
        if (((String)prefix).endsWith("/")) {
            prefix = ((String)prefix).substring(0, ((String)prefix).length() - 1);
        }
        return prefix;
    }
}

