/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.reactive.server.handlers;

import java.io.ByteArrayInputStream;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import javax.ws.rs.core.Response;
import org.jboss.resteasy.reactive.RestResponse;
import org.jboss.resteasy.reactive.common.jaxrs.ResponseImpl;
import org.jboss.resteasy.reactive.common.jaxrs.RestResponseImpl;
import org.jboss.resteasy.reactive.server.core.EncodedMediaType;
import org.jboss.resteasy.reactive.server.core.LazyResponse;
import org.jboss.resteasy.reactive.server.core.ResteasyReactiveRequestContext;
import org.jboss.resteasy.reactive.server.jaxrs.ResponseBuilderImpl;
import org.jboss.resteasy.reactive.server.spi.ServerRestHandler;

public class ResponseHandler
implements ServerRestHandler {
    @Override
    public void handle(final ResteasyReactiveRequestContext requestContext) throws Exception {
        final Object result = requestContext.getResult();
        if (result instanceof Response) {
            ResponseBuilderImpl responseBuilder;
            boolean mediaTypeAlreadyExists = false;
            Response existing = (Response)result;
            if (existing.getEntity() instanceof GenericEntity) {
                GenericEntity genericEntity = (GenericEntity)existing.getEntity();
                requestContext.setGenericReturnType(genericEntity.getType());
                responseBuilder = this.fromResponse(existing);
                responseBuilder.entity(genericEntity.getEntity());
            } else {
                if (existing.hasEntity() && existing.getEntity() != null) {
                    requestContext.setGenericReturnType(existing.getEntity().getClass());
                }
                responseBuilder = this.fromResponse(existing);
                if (result instanceof ResponseImpl) {
                    ResponseImpl responseImpl = (ResponseImpl)result;
                    if (responseImpl.getEntityAnnotations() != null) {
                        requestContext.setAdditionalAnnotations(responseImpl.getEntityAnnotations());
                    }
                    if (responseBuilder.getEntity() == null && responseImpl.getEntityStream() instanceof ByteArrayInputStream) {
                        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)responseImpl.getEntityStream();
                        responseBuilder.entity(byteArrayInputStream.readAllBytes());
                    }
                }
            }
            if (existing.getMediaType() != null) {
                requestContext.setResponseContentType(existing.getMediaType());
                mediaTypeAlreadyExists = true;
            }
            EncodedMediaType produces = requestContext.getResponseContentType();
            if (!mediaTypeAlreadyExists && produces != null) {
                responseBuilder.header("Content-Type", produces.toString());
            }
            if (responseBuilder instanceof ResponseBuilderImpl) {
                requestContext.setResponse(new LazyResponse.Existing((Response)responseBuilder.build(false)));
            } else {
                requestContext.setResponse(new LazyResponse.Existing((Response)responseBuilder.build()));
            }
        } else if (result instanceof RestResponse) {
            ResponseBuilderImpl responseBuilder;
            boolean mediaTypeAlreadyExists = false;
            RestResponse existing = (RestResponse)result;
            if (existing.getEntity() instanceof GenericEntity) {
                GenericEntity genericEntity = (GenericEntity)existing.getEntity();
                requestContext.setGenericReturnType(genericEntity.getType());
                responseBuilder = this.fromResponse(existing);
                responseBuilder.entity(genericEntity.getEntity());
            } else {
                if (existing.hasEntity() && existing.getEntity() != null) {
                    requestContext.setGenericReturnType(existing.getEntity().getClass());
                }
                responseBuilder = this.fromResponse(existing);
                if (result instanceof RestResponseImpl) {
                    RestResponseImpl responseImpl = (RestResponseImpl)result;
                    if (responseImpl.getEntityAnnotations() != null) {
                        requestContext.setAdditionalAnnotations(responseImpl.getEntityAnnotations());
                    }
                    if (responseBuilder.getEntity() == null && responseImpl.getEntityStream() instanceof ByteArrayInputStream) {
                        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)responseImpl.getEntityStream();
                        responseBuilder.entity(byteArrayInputStream.readAllBytes());
                    }
                }
            }
            if (existing.getMediaType() != null) {
                requestContext.setResponseContentType(existing.getMediaType());
                mediaTypeAlreadyExists = true;
            }
            EncodedMediaType produces = requestContext.getResponseContentType();
            if (!mediaTypeAlreadyExists && produces != null) {
                responseBuilder.header("Content-Type", produces.toString());
            }
            if (responseBuilder instanceof ResponseBuilderImpl) {
                requestContext.setResponse(new LazyResponse.Existing((Response)responseBuilder.build(false)));
            } else {
                requestContext.setResponse(new LazyResponse.Existing((Response)responseBuilder.build()));
            }
        } else {
            requestContext.setResponse(new LazyResponse(){
                Response response;

                @Override
                public Response get() {
                    if (this.response == null) {
                        Response.ResponseBuilder responseBuilder;
                        if (result instanceof GenericEntity) {
                            GenericEntity genericEntity = (GenericEntity)result;
                            requestContext.setGenericReturnType(genericEntity.getType());
                            responseBuilder = ResponseImpl.ok((Object)genericEntity.getEntity());
                        } else {
                            responseBuilder = result == null ? ResponseImpl.noContent() : ResponseImpl.ok((Object)result);
                        }
                        EncodedMediaType produces = requestContext.getResponseContentType();
                        if (produces != null) {
                            responseBuilder.header("Content-Type", (Object)produces.toString());
                        }
                        this.response = responseBuilder instanceof ResponseBuilderImpl ? ((ResponseBuilderImpl)responseBuilder).build(false) : responseBuilder.build();
                    }
                    return this.response;
                }

                @Override
                public boolean isCreated() {
                    return this.response != null;
                }
            });
        }
    }

    private ResponseBuilderImpl fromResponse(Response response) {
        Response.ResponseBuilder b = new ResponseBuilderImpl().status(response.getStatus());
        if (response.hasEntity()) {
            b.entity(response.getEntity());
        }
        for (String headerName : response.getHeaders().keySet()) {
            List headerValues = (List)response.getHeaders().get((Object)headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return (ResponseBuilderImpl)b;
    }

    private ResponseBuilderImpl fromResponse(RestResponse<?> response) {
        Response.ResponseBuilder b = new ResponseBuilderImpl().status(response.getStatus());
        if (response.hasEntity()) {
            b.entity(response.getEntity());
        }
        for (String headerName : response.getHeaders().keySet()) {
            List headerValues = (List)response.getHeaders().get((Object)headerName);
            for (Object headerValue : headerValues) {
                b.header(headerName, headerValue);
            }
        }
        return (ResponseBuilderImpl)b;
    }
}

