/*
 * Decompiled with CFR 0.152.
 */
package ratpack.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.ImmutableList;
import com.google.common.io.ByteSource;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.Properties;
import ratpack.config.ConfigData;
import ratpack.config.ConfigSource;
import ratpack.config.EnvironmentParser;
import ratpack.func.Action;
import ratpack.func.Function;

public interface ConfigDataSpec {
    public ConfigDataSpec configureObjectMapper(Action<ObjectMapper> var1);

    public ConfigDataSpec add(ConfigSource var1);

    public ConfigData build();

    public ConfigDataSpec env();

    public ConfigDataSpec env(String var1);

    public ConfigDataSpec env(String var1, Function<String, String> var2);

    public ConfigDataSpec env(EnvironmentParser var1);

    public ConfigDataSpec json(ByteSource var1);

    public ConfigDataSpec json(Path var1);

    default public ConfigDataSpec json(String path) {
        return this.json(Paths.get(path, new String[0]));
    }

    public ConfigDataSpec json(URL var1);

    public ConfigDataSpec props(ByteSource var1);

    public ConfigDataSpec props(Path var1);

    public ConfigDataSpec props(Properties var1);

    public ConfigDataSpec props(Map<String, String> var1);

    default public ConfigDataSpec props(String path) {
        return this.props(Paths.get(path, new String[0]));
    }

    public ConfigDataSpec props(URL var1);

    public ConfigDataSpec sysProps();

    public ConfigDataSpec sysProps(String var1);

    public ConfigDataSpec yaml(ByteSource var1);

    public ConfigDataSpec yaml(Path var1);

    default public ConfigDataSpec yaml(String path) {
        return this.yaml(Paths.get(path, new String[0]));
    }

    public ConfigDataSpec yaml(URL var1);

    public ConfigDataSpec onError(Action<? super Throwable> var1);

    public ObjectMapper getObjectMapper();

    public ImmutableList<ConfigSource> getConfigSources();
}

