/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec;

import java.util.concurrent.Callable;
import org.reactivestreams.Publisher;
import ratpack.exec.ExecBuilder;
import ratpack.exec.ExecController;
import ratpack.exec.ExecInterceptor;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.UnmanagedThreadException;
import ratpack.exec.internal.DefaultOperation;
import ratpack.exec.internal.JustInTimeExecControl;
import ratpack.func.Action;
import ratpack.func.Block;
import ratpack.func.Factory;
import ratpack.stream.TransformablePublisher;

public interface ExecControl {
    public static ExecControl current() throws UnmanagedThreadException {
        return ExecController.require().getControl();
    }

    public static ExecControl execControl() {
        return JustInTimeExecControl.INSTANCE;
    }

    public Execution getExecution() throws UnmanagedThreadException;

    public ExecController getController();

    public void addInterceptor(ExecInterceptor var1, Block var2) throws Exception;

    public <T> Promise<T> blocking(Callable<T> var1);

    default public Operation blockingOperation(Block block) {
        return this.blocking(() -> {
            block.execute();
            return null;
        }).operation();
    }

    public <T> Promise<T> promise(Action<? super Fulfiller<T>> var1);

    default public <T> Promise<T> promiseOf(T item) {
        return this.promise(f -> f.success(item));
    }

    default public <T> Promise<T> promiseFrom(Factory<? extends T> factory) {
        return this.promise(f -> f.success(factory.create()));
    }

    default public <T> Promise<T> failedPromise(Throwable error) {
        return this.promise(f -> f.error(error));
    }

    default public <T> Promise<T> wrap(Factory<? extends Promise<T>> factory) {
        try {
            return factory.create();
        }
        catch (Exception e) {
            return this.failedPromise(e);
        }
    }

    default public Operation operation(Block operation) {
        return new DefaultOperation(this.promise(f -> {
            operation.execute();
            f.success(null);
        }));
    }

    default public void nest(Block nested, Block then) {
        this.operation(nested).then(then);
    }

    default public void nest(Block nested, Block then, Action<? super Throwable> onError) {
        this.operation(nested).onError(onError).then(then);
    }

    public ExecBuilder fork();

    public <T> TransformablePublisher<T> stream(Publisher<T> var1);
}

