/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.internal;

import java.util.Optional;
import ratpack.exec.ExecController;
import ratpack.exec.ExecutionException;
import ratpack.exec.UnmanagedThreadException;

public class ThreadBinding {
    private final boolean compute;
    private final ExecController execController;
    private static final ThreadLocal<ThreadBinding> STORAGE = new ThreadLocal();

    public ThreadBinding(boolean compute, ExecController execController) {
        this.compute = compute;
        this.execController = execController;
    }

    static void bind(boolean compute, ExecController execController) {
        STORAGE.set(new ThreadBinding(compute, execController));
    }

    public static Optional<ThreadBinding> get() {
        return Optional.ofNullable(STORAGE.get());
    }

    public boolean isCompute() {
        return this.compute;
    }

    public ExecController getExecController() {
        return this.execController;
    }

    public static void requireComputeThread(String message) {
        if (!ThreadBinding.get().orElseThrow(UnmanagedThreadException::new).isCompute()) {
            throw new ExecutionException(ThreadBinding.toMessage(message));
        }
    }

    public static void requireBlockingThread(String message) {
        if (ThreadBinding.get().orElseThrow(UnmanagedThreadException::new).isCompute()) {
            throw new ExecutionException(ThreadBinding.toMessage(message));
        }
    }

    private static String toMessage(String message) {
        return message + " - current thread name = '" + Thread.currentThread().getName() + "'.";
    }
}

