/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Executors;
import ratpack.file.CachingFileSystemChecksumService;
import ratpack.file.FileSystemBinding;
import ratpack.file.FileSystemChecksumService;
import ratpack.file.checksummer.Adler32Checksummer;
import ratpack.file.checksummer.MD5Checksummer;
import ratpack.file.internal.DefaultFileSystemChecksumService;
import ratpack.file.internal.FileSystemChecksumServicePopulater;
import ratpack.func.Function;
import ratpack.server.ServerConfig;

public abstract class FileSystemChecksumServices {
    private FileSystemChecksumServices() {
    }

    public static FileSystemChecksumService service(ServerConfig serverConfig) {
        return FileSystemChecksumServices.service(serverConfig, new Adler32Checksummer());
    }

    public static FileSystemChecksumService service(ServerConfig serverConfig, Function<? super InputStream, ? extends String> checksummerFunc) {
        return FileSystemChecksumServices.service(serverConfig, checksummerFunc, null, new String[0]);
    }

    public static FileSystemChecksumService service(ServerConfig serverConfig, Function<? super InputStream, ? extends String> checksummerFunc, String path, String ... fileEndsWith) {
        Function<? super InputStream, ? extends String> checksummer = checksummerFunc != null ? checksummerFunc : FileSystemChecksumServices.noopChecksummer();
        FileSystemBinding fsb = path != null ? serverConfig.getBaseDir().binding(path) : serverConfig.getBaseDir();
        List<String> exts = Arrays.asList(fileEndsWith);
        if (fsb == null || !Files.isDirectory(fsb.getFile(), new LinkOption[0])) {
            throw new IllegalArgumentException("Non existing path related to server's base dir.");
        }
        DefaultFileSystemChecksumService service = new DefaultFileSystemChecksumService(fsb, checksummer, exts);
        if (serverConfig.isDevelopment()) {
            return service;
        }
        CachingFileSystemChecksumService cachingService = new CachingFileSystemChecksumService(service);
        new FileSystemChecksumServicePopulater(fsb.getFile(), exts, cachingService, Executors.newFixedThreadPool(5), 4).start();
        return cachingService;
    }

    public static FileSystemChecksumService adler32(ServerConfig serverConfig, String path, String ... fileEndsWith) {
        return FileSystemChecksumServices.service(serverConfig, new Adler32Checksummer(), path, fileEndsWith);
    }

    public static FileSystemChecksumService md5(ServerConfig serverConfig, String path, String ... fileEndsWith) {
        return FileSystemChecksumServices.service(serverConfig, new MD5Checksummer(), path, fileEndsWith);
    }

    private static Function<InputStream, String> noopChecksummer() {
        return is -> "";
    }
}

