/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.List;
import ratpack.file.FileSystemBinding;
import ratpack.file.FileSystemChecksumService;
import ratpack.func.Function;

public class DefaultFileSystemChecksumService
implements FileSystemChecksumService {
    private final Function<? super InputStream, ? extends String> checksummer;
    private final FileSystemBinding fileSystemBinding;
    private final List<String> fileEndsWith;

    public DefaultFileSystemChecksumService(FileSystemBinding fileSystemBinding, Function<? super InputStream, ? extends String> checksummer, List<String> fileEndsWith) {
        this.checksummer = checksummer;
        this.fileSystemBinding = fileSystemBinding;
        this.fileEndsWith = fileEndsWith;
    }

    @Override
    public String checksum(String path) throws Exception {
        if (path == null) {
            return null;
        }
        Path child = this.fileSystemBinding.file(path);
        if (child == null) {
            throw new NoSuchFileException(path);
        }
        if (this.fileEndsWith != null && !this.fileEndsWith.isEmpty() && !this.fileEndsWith.stream().anyMatch(s -> path.endsWith((String)s))) {
            throw new NoSuchFileException(child.toString());
        }
        return this.getChecksum(child);
    }

    private String getChecksum(Path child) throws Exception {
        try (InputStream inputStream = Files.newInputStream(child, StandardOpenOption.READ);){
            String string = this.checksummer.apply(inputStream);
            return string;
        }
    }
}

