/*
 * Decompiled with CFR 0.152.
 */
package ratpack.file.internal;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.concurrent.ExecutionException;
import ratpack.file.BaseDirRequiredException;
import ratpack.file.FileSystemBinding;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.registry.Registries;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;

public class FileSystemBindingHandler
implements Handler {
    private final String path;
    private final Handler handler;
    private static final LoadingCache<FileSystemBinding, Registry> CACHE = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<FileSystemBinding, Registry>(){

        public Registry load(FileSystemBinding key) throws Exception {
            return Registries.just(FileSystemBinding.class, key);
        }
    });

    public FileSystemBindingHandler(ServerConfig serverConfig, String path, Handler handler) {
        if (!serverConfig.isHasBaseDir()) {
            throw new BaseDirRequiredException("An application base directory is required to use this handler");
        }
        this.path = path;
        this.handler = handler;
    }

    @Override
    public void handle(Context context) throws ExecutionException {
        FileSystemBinding parentBinding = context.get(FileSystemBinding.class);
        FileSystemBinding binding = parentBinding.binding(this.path);
        if (binding == null) {
            context.clientError(404);
        } else {
            context.insert((Registry)CACHE.get((Object)binding), this.handler);
        }
    }
}

