/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.temporal.ChronoUnit;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.http.Response;

public class ResponseTimer
implements Handler {
    private static final BigDecimal NANOS_IN_MILLIS = BigDecimal.valueOf(ChronoUnit.MILLIS.getDuration().toNanos());
    public static final String HEADER_NAME = "X-Response-Time";

    public static HandlerDecorator decorator() {
        return HandlerDecorator.prepend(new ResponseTimer());
    }

    @Override
    public void handle(Context ctx) {
        long start = System.nanoTime();
        Response response = ctx.getResponse();
        response.beforeSend(m -> {
            long stop = System.nanoTime();
            BigDecimal diffNanos = new BigDecimal(stop - start);
            BigDecimal diffMicros = diffNanos.divide(NANOS_IN_MILLIS, 5, RoundingMode.UP);
            m.getHeaders().set((CharSequence)HEADER_NAME, diffMicros.toString());
        });
        ctx.next();
    }
}

