/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.client.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpObjectAggregator;
import java.net.URI;
import ratpack.exec.Execution;
import ratpack.exec.Fulfiller;
import ratpack.func.Action;
import ratpack.http.client.ReceivedResponse;
import ratpack.http.client.RequestSpec;
import ratpack.http.client.internal.DefaultReceivedResponse;
import ratpack.http.client.internal.RequestActionSupport;
import ratpack.http.internal.ByteBufBackedTypedData;
import ratpack.http.internal.DefaultMediaType;
import ratpack.http.internal.DefaultStatus;
import ratpack.http.internal.HttpHeaderConstants;
import ratpack.http.internal.NettyHeadersBackedHeaders;

class ContentAggregatingRequestAction
extends RequestActionSupport<ReceivedResponse> {
    private final int maxContentLengthBytes;

    public ContentAggregatingRequestAction(Action<? super RequestSpec> requestConfigurer, URI uri, Execution execution, ByteBufAllocator byteBufAllocator, int maxContentLengthBytes) {
        super(requestConfigurer, uri, execution, byteBufAllocator);
        this.maxContentLengthBytes = maxContentLengthBytes;
    }

    @Override
    protected void addResponseHandlers(ChannelPipeline p, final Fulfiller<? super ReceivedResponse> fulfiller) {
        p.addLast("aggregator", (ChannelHandler)new HttpObjectAggregator(this.maxContentLengthBytes));
        p.addLast("httpResponseHandler", (ChannelHandler)new SimpleChannelInboundHandler<FullHttpResponse>(false){

            public void channelRead0(ChannelHandlerContext ctx, FullHttpResponse msg) throws Exception {
                NettyHeadersBackedHeaders headers = new NettyHeadersBackedHeaders(msg.headers());
                String contentType = headers.get(HttpHeaderConstants.CONTENT_TYPE.toString());
                ByteBuf responseBuffer = ContentAggregatingRequestAction.initBufferReleaseOnExecutionClose(msg.content(), ContentAggregatingRequestAction.this.execution);
                ByteBufBackedTypedData typedData = new ByteBufBackedTypedData(responseBuffer, DefaultMediaType.get(contentType));
                DefaultStatus status = new DefaultStatus(msg.status());
                ContentAggregatingRequestAction.this.success(fulfiller, new DefaultReceivedResponse(status, headers, typedData));
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
                ContentAggregatingRequestAction.this.error(fulfiller, cause);
            }
        });
    }

    @Override
    protected RequestActionSupport<ReceivedResponse> buildRedirectRequestAction(Action<? super RequestSpec> redirectRequestConfig, URI locationUrl) {
        return new ContentAggregatingRequestAction(redirectRequestConfig, locationUrl, this.execution, this.byteBufAllocator, this.maxContentLengthBytes);
    }

    private static ByteBuf initBufferReleaseOnExecutionClose(ByteBuf responseBuffer, Execution execution) {
        execution.onCleanup(() -> ((ByteBuf)responseBuffer).release());
        return responseBuffer;
    }
}

