/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.Arrays;
import java.util.List;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.internal.MimeParse;

public class AcceptsHandler
implements Handler {
    private final List<String> contentTypes;

    public AcceptsHandler(String ... contentTypes) {
        this.contentTypes = Arrays.asList(contentTypes);
    }

    @Override
    public void handle(Context context) throws Exception {
        String acceptHeader = context.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (acceptHeader == null || acceptHeader.isEmpty()) {
            context.clientError(406);
        } else {
            String winner = MimeParse.bestMatch(this.contentTypes, acceptHeader);
            if (winner == null || winner.isEmpty()) {
                context.clientError(406);
            } else {
                context.next();
            }
        }
    }
}

