/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.internal.MimeParse;

public class ContentNegotiationHandler
implements Handler {
    private final ImmutableMap<String, Handler> handlers;
    private final Handler noMatchHandler;

    public ContentNegotiationHandler(Map<String, Handler> handlers, Handler noMatchHandler) {
        this.handlers = ImmutableMap.copyOf(handlers);
        this.noMatchHandler = noMatchHandler;
    }

    @Override
    public void handle(Context context) throws Exception {
        if (this.handlers.isEmpty()) {
            this.noMatchHandler.handle(context);
            return;
        }
        ArrayList types = Lists.newArrayList((Iterable)this.handlers.keySet());
        String winner = (String)types.get(0);
        Collections.reverse(types);
        String acceptHeader = context.getRequest().getHeaders().get((CharSequence)HttpHeaderNames.ACCEPT);
        if (!Strings.isNullOrEmpty((String)acceptHeader)) {
            winner = MimeParse.bestMatch(types, acceptHeader);
        }
        if (Strings.isNullOrEmpty((String)winner)) {
            this.noMatchHandler.handle(context);
        } else {
            context.getResponse().contentType(winner);
            ((Handler)this.handlers.get((Object)winner)).handle(context);
        }
    }
}

