/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.http.HttpMethod;
import ratpack.http.Response;
import ratpack.http.internal.DefaultHttpMethod;
import ratpack.http.internal.HttpHeaderConstants;

public class MethodHandler
implements Handler {
    private final HttpMethod method;
    public static final Handler GET = new MethodHandler("GET");
    public static final Handler POST = new MethodHandler("POST");
    public static final Handler PUT = new MethodHandler("PUT");
    public static final Handler PATCH = new MethodHandler("PATCH");
    public static final Handler DELETE = new MethodHandler("DELETE");

    private MethodHandler(String method) {
        this.method = DefaultHttpMethod.valueOf(io.netty.handler.codec.http.HttpMethod.valueOf((String)method));
    }

    @Override
    public void handle(Context context) {
        HttpMethod requestMethod = context.getRequest().getMethod();
        if (requestMethod == this.method || requestMethod.name(this.method.getName())) {
            context.next();
        } else if (requestMethod.isOptions()) {
            Response response = context.getResponse();
            response.getHeaders().add(HttpHeaderConstants.ALLOW, this.method);
            response.status(200).send();
        } else {
            context.clientError(405);
        }
    }
}

