/*
 * Decompiled with CFR 0.152.
 */
package ratpack.http.internal;

import com.google.common.base.Joiner;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.util.Map;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.Handlers;
import ratpack.http.HttpMethod;
import ratpack.http.internal.HttpHeaderConstants;

public class MultiMethodHandler
implements Handler {
    private static final Handler NO_METHOD_HANDLER = Handlers.clientError(HttpResponseStatus.METHOD_NOT_ALLOWED.code());
    private final Map<String, Handler> handlers;

    public MultiMethodHandler(Map<String, Handler> handlers) {
        this.handlers = handlers;
    }

    @Override
    public void handle(Context context) throws Exception {
        HttpMethod method = context.getRequest().getMethod();
        if (method.isOptions()) {
            String methods = Joiner.on((String)",").join(this.handlers.keySet());
            context.getResponse().getHeaders().add(HttpHeaderConstants.ALLOW, methods);
            context.getResponse().status(200).send();
        } else {
            for (Map.Entry<String, Handler> entry : this.handlers.entrySet()) {
                String key = entry.getKey();
                if (!method.name(key)) continue;
                try {
                    entry.getValue().handle(context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw e;
                }
                return;
            }
            NO_METHOD_HANDLER.handle(context);
        }
    }
}

