/*
 * Decompiled with CFR 0.152.
 */
package ratpack.path.internal;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import ratpack.path.PathBinding;
import ratpack.path.PathTokens;
import ratpack.path.internal.DefaultPathTokens;
import ratpack.util.internal.Validations;

public class DefaultPathBinding
implements PathBinding {
    private final String binding;
    private final String bindingWithSlash;
    private final String pastBinding;
    private final PathTokens tokens;
    private final PathTokens allTokens;

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultPathBinding that = (DefaultPathBinding)o;
        return this.allTokens.equals(that.allTokens) && this.binding.equals(that.binding) && this.pastBinding.equals(that.pastBinding);
    }

    public int hashCode() {
        int result = this.binding.hashCode();
        result = 31 * result + this.pastBinding.hashCode();
        result = 31 * result + this.allTokens.hashCode();
        return result;
    }

    public DefaultPathBinding(String path, String binding, ImmutableMap<String, String> tokens, Optional<PathBinding> parent) {
        this.binding = binding;
        this.bindingWithSlash = binding.concat("/");
        this.tokens = new DefaultPathTokens(tokens);
        this.allTokens = parent.isPresent() ? new DefaultPathTokens((ImmutableMap<String, String>)ImmutableMap.builder().putAll((Map)parent.get().getAllTokens()).putAll(tokens).build()) : this.tokens;
        if (path.equals(binding)) {
            this.pastBinding = "";
        } else if (path.startsWith(this.bindingWithSlash)) {
            this.pastBinding = path.substring(this.bindingWithSlash.length());
        } else {
            throw new IllegalArgumentException(String.format("Path '%s' is not a child of '%s'", path, binding));
        }
    }

    @Override
    public String getPastBinding() {
        return this.pastBinding;
    }

    @Override
    public String getBoundTo() {
        return this.binding;
    }

    @Override
    public String childPath(String path) {
        Validations.noLeadingForwardSlash(path, "child path");
        return this.bindingWithSlash.concat(path);
    }

    @Override
    public PathTokens getTokens() {
        return this.tokens;
    }

    @Override
    public PathTokens getAllTokens() {
        return this.allTokens;
    }
}

