/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.Iterables;
import com.google.common.reflect.TypeToken;
import java.util.Optional;
import ratpack.func.Function;
import ratpack.registry.Registry;

public class HierarchicalRegistry
implements Registry {
    private final Registry parent;
    private final Registry child;

    public HierarchicalRegistry(Registry parent, Registry child) {
        this.parent = parent;
        this.child = child;
    }

    @Override
    public <O> Optional<O> maybeGet(TypeToken<O> type) {
        Optional<O> object = this.child.maybeGet(type);
        if (!object.isPresent()) {
            object = this.parent.maybeGet(type);
        }
        return object;
    }

    @Override
    public <O> Iterable<? extends O> getAll(TypeToken<O> type) {
        Iterable<O> childAll = this.child.getAll(type);
        Iterable<O> parentAll = this.parent.getAll(type);
        return Iterables.concat(childAll, parentAll);
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        Optional<O> first = this.child.first(type, function);
        if (!first.isPresent()) {
            first = this.parent.first(type, function);
        }
        return first;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HierarchicalRegistry that = (HierarchicalRegistry)o;
        return this.child.equals(that.child) && this.parent.equals(that.parent);
    }

    public int hashCode() {
        int result = this.parent.hashCode();
        result = 31 * result + this.child.hashCode();
        return result;
    }

    public String toString() {
        return "HierarchicalRegistry{parent=" + this.parent + ", child=" + this.child + '}';
    }
}

