/*
 * Decompiled with CFR 0.152.
 */
package ratpack.render;

import com.google.common.reflect.TypeParameter;
import com.google.common.reflect.TypeToken;
import java.util.function.BiConsumer;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.registry.RegistrySpec;
import ratpack.util.Types;

public interface Renderer<T> {
    default public Action<RegistrySpec> register() {
        return registrySpec -> registrySpec.add(Renderer.typeOf(this.getType()), this);
    }

    public static <T> TypeToken<Renderer<? super T>> typeCompatibleOf(T toRender) {
        Class clazz = (Class)Types.cast(toRender.getClass());
        return new TypeToken<Renderer<? super T>>(clazz){}.where(new TypeParameter<T>(){}, clazz);
    }

    public static <T> Renderer<T> of(final Class<T> type, final BiConsumer<? super Context, ? super T> impl) {
        return new Renderer<T>(){

            @Override
            public Class<T> getType() {
                return type;
            }

            @Override
            public void render(Context context, T object) throws Exception {
                impl.accept(context, object);
            }
        };
    }

    public static <T> TypeToken<Renderer<T>> typeOf(Class<T> typeToRender) {
        return new TypeToken<Renderer<T>>(typeToRender){}.where(new TypeParameter<T>(){}, typeToRender);
    }

    public Class<T> getType();

    public void render(Context var1, T var2) throws Exception;
}

