/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.sun.nio.zipfs.ZipFileSystemProvider;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import ratpack.util.Exceptions;

public abstract class BaseDirFinder {
    private static final String BASE_DIR_OVERRIDE = "ratpack.baseDir.override";

    public static Optional<Result> find(ClassLoader classLoader, String resourcePathString) {
        File overrideMarkerFile;
        File overrideDir;
        String override = System.getProperties().getProperty(BASE_DIR_OVERRIDE);
        if (override != null && (overrideDir = new File(override)).isDirectory() && (overrideMarkerFile = new File(overrideDir, resourcePathString)).isFile()) {
            Path resourcePath = overrideMarkerFile.toPath();
            return Optional.of(new Result(BaseDirFinder.determineBaseDir(resourcePath), resourcePath));
        }
        URL resourceUrl = classLoader.getResource(resourcePathString);
        if (resourceUrl == null) {
            return Optional.empty();
        }
        Path resourcePath = BaseDirFinder.toPath(resourceUrl);
        return Optional.of(new Result(BaseDirFinder.determineBaseDir(resourcePath), resourcePath));
    }

    private static Path toPath(URL resource) {
        URI uri = Exceptions.uncheck(resource::toURI);
        String scheme = uri.getScheme();
        if (scheme.equals("file")) {
            return Paths.get(uri);
        }
        if (!scheme.equals("jar")) {
            throw new IllegalStateException("Cannot deal with class path resource url: " + uri);
        }
        String s = uri.toString();
        int separator = s.indexOf("!/");
        String entryName = s.substring(separator + 2);
        URI fileURI = URI.create(s.substring(0, separator));
        FileSystem fs = null;
        try {
            fs = FileSystems.getFileSystem(fileURI);
            if (!fs.isOpen()) {
                fs = null;
            }
        }
        catch (FileSystemNotFoundException ignore) {
            // empty catch block
        }
        if (fs == null) {
            try {
                fs = FileSystems.newFileSystem(fileURI, ImmutableMap.of());
            }
            catch (IOException e) {
                throw Exceptions.uncheck(e);
            }
        }
        return fs.getPath(entryName, new String[0]);
    }

    private static Path determineBaseDir(Path configPath) {
        Path baseDir = configPath.getParent();
        if (baseDir == null && configPath.getFileSystem().provider() instanceof ZipFileSystemProvider) {
            baseDir = (Path)Iterables.getFirst(configPath.getFileSystem().getRootDirectories(), null);
        }
        if (baseDir == null) {
            throw new IllegalStateException("Cannot determine base dir given config resource: " + configPath);
        }
        return baseDir;
    }

    public static class Result {
        private final Path baseDir;
        private final Path resource;

        private Result(Path baseDir, Path resource) {
            this.baseDir = baseDir;
            this.resource = resource;
        }

        public Path getBaseDir() {
            return this.baseDir;
        }

        public Path getResource() {
            return this.resource;
        }

        public String toString() {
            return "Result{baseDir=" + this.baseDir + ", resource=" + this.resource + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Result result = (Result)o;
            return this.baseDir.equals(result.baseDir) && this.resource.equals(result.resource);
        }

        public int hashCode() {
            int result = this.baseDir.hashCode();
            result = 31 * result + this.resource.hashCode();
            return result;
        }
    }
}

