/*
 * Decompiled with CFR 0.152.
 */
package ratpack.server.internal;

import com.google.common.collect.ImmutableSet;
import java.net.InetAddress;
import java.net.URI;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import ratpack.config.ConfigData;
import ratpack.config.ConfigObject;
import ratpack.config.internal.DelegatingConfigData;
import ratpack.file.FileSystemBinding;
import ratpack.file.internal.DefaultFileSystemBinding;
import ratpack.server.NoBaseDirException;
import ratpack.server.ServerConfig;
import ratpack.server.internal.ServerConfigData;

public class DefaultServerConfig
extends DelegatingConfigData
implements ServerConfig {
    private final ServerConfigData serverConfigData;
    private final Optional<FileSystemBinding> baseDir;
    private final ImmutableSet<ConfigObject<?>> requiredConfig;

    public DefaultServerConfig(ConfigData configData, ImmutableSet<ConfigObject<?>> requiredConfig) {
        super(configData);
        this.requiredConfig = requiredConfig;
        this.serverConfigData = this.get("/server", ServerConfigData.class);
        this.baseDir = Optional.ofNullable(this.serverConfigData.getBaseDir()).map(DefaultFileSystemBinding::new);
    }

    @Override
    public int getPort() {
        return this.serverConfigData.getPort();
    }

    @Override
    public InetAddress getAddress() {
        return this.serverConfigData.getAddress();
    }

    @Override
    public ImmutableSet<ConfigObject<?>> getRequiredConfig() {
        return this.requiredConfig;
    }

    @Override
    public boolean isDevelopment() {
        return this.serverConfigData.isDevelopment();
    }

    @Override
    public int getThreads() {
        return this.serverConfigData.getThreads();
    }

    @Override
    public URI getPublicAddress() {
        return this.serverConfigData.getPublicAddress();
    }

    @Override
    public SSLContext getSSLContext() {
        return this.serverConfigData.getSslContext();
    }

    @Override
    public int getMaxContentLength() {
        return this.serverConfigData.getMaxContentLength();
    }

    @Override
    public boolean isHasBaseDir() {
        return this.serverConfigData.getBaseDir() != null;
    }

    @Override
    public FileSystemBinding getBaseDir() throws NoBaseDirException {
        return this.baseDir.orElseThrow(() -> new NoBaseDirException("No base dir has been set"));
    }
}

