/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicBoolean;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.stream.TransformablePublisher;

public class MulticastPublisher<T>
implements TransformablePublisher<T> {
    private final ConcurrentLinkedDeque<Subscriber<? super T>> bufferedSubscribers = new ConcurrentLinkedDeque();
    private final Publisher<T> upstreamPublisher;
    private final AtomicBoolean requestedUpstream;
    private final AtomicBoolean upstreamFinished;

    public MulticastPublisher(Publisher<T> publisher) {
        this.upstreamPublisher = publisher;
        this.requestedUpstream = new AtomicBoolean();
        this.upstreamFinished = new AtomicBoolean();
    }

    public void subscribe(Subscriber<? super T> downStreamSubscriber) {
        if (this.upstreamFinished.get()) {
            downStreamSubscriber.onError((Throwable)new IllegalStateException("The upstream publisher has completed, either successfully or with error.  No further subscriptions will be accepted"));
        } else {
            ((TransformablePublisher)s -> s.onSubscribe(new Subscription(){

                public void request(long n) {
                    MulticastPublisher.this.bufferedSubscribers.add(s);
                    MulticastPublisher.this.tryUpstreamSubscribe();
                }

                public void cancel() {
                    MulticastPublisher.this.bufferedSubscribers.remove(s);
                }
            })).buffer().subscribe(downStreamSubscriber);
        }
    }

    private void tryUpstreamSubscribe() {
        if (this.requestedUpstream.compareAndSet(false, true)) {
            this.upstreamPublisher.subscribe(new Subscriber<T>(){
                Subscription subscription;

                public void onSubscribe(Subscription s) {
                    this.subscription = s;
                    this.subscription.request(Long.MAX_VALUE);
                }

                public void onNext(T t) {
                    for (Subscriber subscriber : MulticastPublisher.this.bufferedSubscribers) {
                        subscriber.onNext(t);
                    }
                }

                public void onError(Throwable t) {
                    MulticastPublisher.this.upstreamFinished.set(true);
                    for (Subscriber subscriber : MulticastPublisher.this.bufferedSubscribers) {
                        subscriber.onError(t);
                    }
                }

                public void onComplete() {
                    MulticastPublisher.this.upstreamFinished.set(true);
                    for (Subscriber subscriber : MulticastPublisher.this.bufferedSubscribers) {
                        subscriber.onComplete();
                    }
                }
            });
        }
    }
}

