/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util.internal;

import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import ratpack.util.MultiValueMap;
import ratpack.util.Types;

public class ImmutableDelegatingMultiValueMap<K, V>
implements MultiValueMap<K, V> {
    private static final ImmutableDelegatingMultiValueMap<Object, Object> EMPTY = new ImmutableDelegatingMultiValueMap(ImmutableMap.of());
    private final Map<K, List<V>> delegate;

    public static <K, V> MultiValueMap<K, V> empty() {
        return (MultiValueMap)Types.cast(EMPTY);
    }

    public ImmutableDelegatingMultiValueMap(Map<K, List<V>> map) {
        this.delegate = map;
    }

    @Override
    public List<V> getAll(K key) {
        return this.delegate.get(key);
    }

    @Override
    public Map<K, List<V>> getAll() {
        return this.delegate;
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.delegate.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        for (List<V> values : this.delegate.values()) {
            if (!values.contains(value)) continue;
            return true;
        }
        return false;
    }

    @Override
    public V get(Object key) {
        List<V> result = this.delegate.get(key);
        return result != null && result.size() > 0 ? (V)result.get(0) : null;
    }

    @Override
    public V put(K key, V value) {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public V remove(Object key) {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("This implementation is immutable");
    }

    @Override
    public ListMultimap<K, V> asMultimap() {
        ImmutableListMultimap.Builder builder = ImmutableListMultimap.builder();
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            builder.putAll(entry.getKey(), (Iterable)entry.getValue());
        }
        return builder.build();
    }

    @Override
    public Set<K> keySet() {
        return this.delegate.keySet();
    }

    @Override
    public Collection<V> values() {
        return Lists.newArrayList((Iterable)Iterables.concat(this.delegate.values()));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate.entrySet().stream().filter(entry -> ((List)entry.getValue()).size() > 0).map(entry -> new AbstractMap.SimpleImmutableEntry(entry.getKey(), ((List)entry.getValue()).get(0))).collect(Collectors.toSet());
    }

    public String toString() {
        if (this.delegate.isEmpty()) {
            return "[:]";
        }
        StringBuilder buffer = new StringBuilder("[");
        boolean first = true;
        for (Map.Entry<K, List<V>> entry : this.delegate.entrySet()) {
            if (first) {
                first = false;
            } else {
                buffer.append(", ");
            }
            buffer.append(entry.getKey().toString());
            buffer.append(":[");
            boolean firstValue = true;
            for (V value : entry.getValue()) {
                if (firstValue) {
                    firstValue = false;
                } else {
                    buffer.append(", ");
                }
                buffer.append(value.toString());
            }
            buffer.append("]");
        }
        buffer.append("]");
        return buffer.toString();
    }
}

