/*
 * Decompiled with CFR 0.152.
 */
package ratpack.handling;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import ratpack.func.Action;
import ratpack.handling.Context;
import ratpack.handling.Handler;
import ratpack.handling.HandlerDecorator;
import ratpack.http.Response;

public class ResponseTimer
implements Handler {
    private static final BigDecimal NANOS_IN_MILLIS = BigDecimal.valueOf(ChronoUnit.MILLIS.getDuration().toNanos());
    public static final String HEADER_NAME = "X-Response-Time";

    public static HandlerDecorator decorator() {
        return HandlerDecorator.prepend(new ResponseTimer());
    }

    @Override
    public void handle(Context ctx) {
        Response response = ctx.getResponse();
        response.beforeSend((Action<? super Response>)((Action)m -> {
            Clock clock = (Clock)ctx.get(Clock.class);
            Instant start = ctx.getRequest().getTimestamp();
            long nanos = start.until(Instant.now(clock), ChronoUnit.NANOS);
            BigDecimal diffNanos = new BigDecimal(nanos);
            BigDecimal diffMillis = diffNanos.divide(NANOS_IN_MILLIS, 5, RoundingMode.UP);
            m.getHeaders().set((CharSequence)HEADER_NAME, diffMillis.toString());
        }));
        ctx.next();
    }
}

