/*
 * Decompiled with CFR 0.152.
 */
package ratpack.exec.util.internal;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import ratpack.exec.ExecResult;
import ratpack.exec.Operation;
import ratpack.exec.Promise;
import ratpack.exec.util.SerialBatch;
import ratpack.func.BiAction;
import ratpack.func.BiFunction;
import ratpack.stream.Streams;
import ratpack.stream.TransformablePublisher;
import ratpack.util.Types;

public class DefaultSerialBatch<T>
implements SerialBatch<T> {
    private final Iterable<? extends Promise<T>> promises;

    public DefaultSerialBatch(Iterable<? extends Promise<T>> promises) {
        this.promises = promises;
    }

    @Override
    public Promise<List<? extends ExecResult<T>>> yieldAll() {
        ArrayList promises = Lists.newArrayList(this.promises);
        List results = (List)Types.cast(promises);
        return Promise.async(d -> DefaultSerialBatch.yieldPromise(promises.iterator(), 0, results::set, (i, r) -> {
            results.set((int)i, r);
            return true;
        }, () -> d.success(results)));
    }

    @Override
    public Promise<List<T>> yield() {
        ArrayList results = new ArrayList();
        return Promise.async(d -> this.forEach((i, r) -> results.add(r)).onError(d::error).then(() -> d.success(results)));
    }

    @Override
    public Operation forEach(BiAction<? super Integer, ? super T> consumer) {
        return Promise.async(d -> DefaultSerialBatch.yieldPromise(this.promises.iterator(), 0, (i, r) -> consumer.execute((Integer)i, (Object)r.getValue()), (i, r) -> {
            d.error(r.getThrowable());
            return false;
        }, () -> d.success(null))).operation();
    }

    @Override
    public TransformablePublisher<T> publisher() {
        Iterator iterator = this.promises.iterator();
        return Streams.flatYield(r -> {
            if (iterator.hasNext()) {
                return (Promise)iterator.next();
            }
            return Promise.ofNull();
        });
    }

    private static <T> void yieldPromise(Iterator<? extends Promise<T>> promises, int i, BiAction<Integer, ExecResult<T>> withItem, BiFunction<Integer, ExecResult<T>, Boolean> onError, Runnable onComplete) {
        if (promises.hasNext()) {
            promises.next().result(r -> {
                if (r.isError()) {
                    if (!((Boolean)onError.apply(i, (ExecResult)r)).booleanValue()) {
                        return;
                    }
                } else {
                    withItem.execute(i, (ExecResult)r);
                }
                DefaultSerialBatch.yieldPromise(promises, i + 1, withItem, onError, onComplete);
            });
        } else {
            onComplete.run();
        }
    }
}

