/*
 * Decompiled with CFR 0.152.
 */
package ratpack.func;

import ratpack.func.Function;
import ratpack.util.Exceptions;
import ratpack.util.Types;

@FunctionalInterface
public interface Predicate<T> {
    public static final Predicate<Object> TRUE = o -> true;
    public static final Predicate<Object> FALSE = o -> false;

    public boolean apply(T var1) throws Exception;

    default public java.util.function.Predicate<T> toPredicate() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    default public com.google.common.base.Predicate<T> toGuavaPredicate() {
        return t -> {
            try {
                return this.apply(t);
            }
            catch (Exception e) {
                throw Exceptions.uncheck(e);
            }
        };
    }

    public static <T> Predicate<T> from(java.util.function.Predicate<T> predicate) {
        return predicate::test;
    }

    public static <T> Predicate<T> fromGuava(com.google.common.base.Predicate<T> predicate) {
        return arg_0 -> predicate.apply(arg_0);
    }

    public static <T> Predicate<T> alwaysTrue() {
        return (Predicate)Types.cast(TRUE);
    }

    public static <T> Predicate<T> alwaysFalse() {
        return (Predicate)Types.cast(FALSE);
    }

    default public <O> Function<T, O> function(O onTrue, O onFalse) {
        return t -> this.apply(t) ? onTrue : onFalse;
    }
}

