/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import ratpack.api.Nullable;
import ratpack.func.Function;
import ratpack.registry.MutableRegistry;
import ratpack.registry.NotInRegistryException;
import ratpack.registry.Registry;
import ratpack.registry.RegistrySpec;
import ratpack.registry.internal.DefaultRegistryEntry;
import ratpack.registry.internal.LazyRegistryEntry;
import ratpack.registry.internal.MultiEntryRegistry;
import ratpack.registry.internal.RegistryEntry;
import ratpack.registry.internal.TypeCaching;

public class SimpleMutableRegistry
implements MutableRegistry {
    private final List<RegistryEntry<?>> entries = new ArrayList();
    private final Registry registry = new MultiEntryRegistry(Lists.reverse(this.entries));

    @Override
    public <O> RegistrySpec addLazy(TypeToken<O> type, Supplier<? extends O> supplier) {
        this.entries.add(new LazyRegistryEntry<O>(type, supplier));
        return this;
    }

    @Override
    public <O> RegistrySpec add(TypeToken<O> type, O object) {
        this.entries.add(new DefaultRegistryEntry<O>(type, object));
        return this;
    }

    @Override
    public <T> void remove(TypeToken<T> type) throws NotInRegistryException {
        Iterator<RegistryEntry<?>> iterator = this.entries.iterator();
        while (iterator.hasNext()) {
            TypeToken<?> entryType = iterator.next().getType();
            if (!TypeCaching.isAssignableFrom(TypeCaching.cache(entryType), entryType, type)) continue;
            iterator.remove();
        }
    }

    @Nullable
    public <T> Optional<T> maybeGet(TypeToken<T> type) {
        return this.registry.maybeGet(type);
    }

    public <T> Iterable<? extends T> getAll(TypeToken<T> type) {
        return this.registry.getAll(type);
    }

    @Override
    public <T, O> Optional<O> first(TypeToken<T> type, Function<? super T, ? extends O> function) throws Exception {
        return this.registry.first(type, function);
    }
}

