/*
 * Decompiled with CFR 0.152.
 */
package ratpack.registry.internal;

import com.google.common.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;
import ratpack.util.internal.Environment;

public abstract class TypeCaching {
    private static final Impl IMPL = Environment.INSTANCE.isDevelopment() ? new Impl() : new CachingImpl();

    public static ConcurrentMap<TypeToken<?>, Boolean> cache(TypeToken<?> left) {
        return IMPL.cache(left);
    }

    public static boolean isAssignableFrom(ConcurrentMap<TypeToken<?>, Boolean> cache, TypeToken<?> left, TypeToken<?> right) {
        return IMPL.isAssignableFrom(cache, left, right);
    }

    public static <T> TypeToken<T> typeToken(Type type) {
        return IMPL.typeToken(type);
    }

    public static <T> TypeToken<T> typeToken(TypeToken<T> type) {
        return IMPL.typeToken(type.getType());
    }

    private static class CachingImpl
    extends Impl {
        private final ConcurrentMap<TypeToken<?>, ConcurrentMap<TypeToken<?>, Boolean>> assignabilityCache = new ConcurrentHashMap();
        private final Function<TypeToken<?>, ConcurrentMap<TypeToken<?>, Boolean>> assignabilityIndexProducer = t -> new ConcurrentHashMap();
        private final ConcurrentMap<Type, TypeToken<?>> typeTokensCache = new ConcurrentHashMap();
        private final Function<Type, TypeToken<?>> typeTokenProducer = TypeToken::of;

        private CachingImpl() {
        }

        @Override
        ConcurrentMap<TypeToken<?>, Boolean> cache(TypeToken<?> left) {
            ConcurrentMap<TypeToken<?>, Boolean> forLeft = (ConcurrentMap<TypeToken<?>, Boolean>)this.assignabilityCache.get(left);
            if (forLeft == null) {
                forLeft = this.assignabilityCache.computeIfAbsent(left, this.assignabilityIndexProducer);
            }
            return forLeft;
        }

        @Override
        boolean isAssignableFrom(ConcurrentMap<TypeToken<?>, Boolean> forLeft, TypeToken<?> left, TypeToken<?> right) {
            Boolean value = (Boolean)forLeft.get(right);
            if (value == null) {
                value = Impl.isAssignableFrom(left, right);
                forLeft.put(right, value);
            }
            return value;
        }

        @Override
        <T> TypeToken<T> typeToken(Type type) {
            TypeToken typeToken = (TypeToken)this.typeTokensCache.get(type);
            if (typeToken == null) {
                return this.typeTokensCache.computeIfAbsent(type, this.typeTokenProducer);
            }
            return typeToken;
        }
    }

    private static class Impl {
        private Impl() {
        }

        ConcurrentMap<TypeToken<?>, Boolean> cache(TypeToken<?> left) {
            return null;
        }

        boolean isAssignableFrom(ConcurrentMap<TypeToken<?>, Boolean> cache, TypeToken<?> left, TypeToken<?> right) {
            return Impl.isAssignableFrom(left, right);
        }

        private static boolean isAssignableFrom(TypeToken<?> left, TypeToken<?> right) {
            return left.equals(right) || left.isSupertypeOf(right);
        }

        <T> TypeToken<T> typeToken(Type type) {
            return TypeToken.of((Type)type);
        }
    }
}

