/*
 * Decompiled with CFR 0.152.
 */
package ratpack.stream.internal;

import java.util.Iterator;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import ratpack.func.Action;
import ratpack.stream.TransformablePublisher;
import ratpack.stream.internal.ManagedSubscription;

public class ConcatPublisher<T>
implements TransformablePublisher<T> {
    private final Iterable<? extends Publisher<? extends T>> publishers;
    private final Action<? super T> disposer;

    public ConcatPublisher(Action<? super T> disposer, Iterable<? extends Publisher<? extends T>> publishers) {
        this.publishers = publishers;
        this.disposer = disposer;
    }

    public void subscribe(Subscriber<? super T> s) {
        s.onSubscribe((Subscription)new ManagedSubscription<T>(s, this.disposer){
            Iterator<? extends Publisher<? extends T>> iterator;
            Subscription current;
            {
                this.iterator = ConcatPublisher.this.publishers.iterator();
            }

            @Override
            protected void onRequest(final long n) {
                if (this.current == null) {
                    if (this.iterator.hasNext()) {
                        Publisher publisher = this.iterator.next();
                        publisher.subscribe(new Subscriber<T>(){

                            public void onSubscribe(Subscription s) {
                                current = s;
                                s.request(n);
                            }

                            public void onNext(T t) {
                                this.emitNext(t);
                            }

                            public void onError(Throwable t) {
                                this.emitError(t);
                            }

                            public void onComplete() {
                                current = null;
                                long demand = this.getDemand();
                                if (demand > 0L) {
                                    this.onRequest(demand);
                                }
                            }
                        });
                    } else {
                        this.emitComplete();
                    }
                } else {
                    this.current.request(n);
                }
            }

            @Override
            protected void onCancel() {
                if (this.current != null) {
                    this.current.cancel();
                }
            }
        });
    }
}

