/*
 * Decompiled with CFR 0.152.
 */
package ratpack.util;

import java.io.IOException;
import java.io.UncheckedIOException;
import ratpack.api.UncheckedException;
import ratpack.func.Action;
import ratpack.func.BiAction;
import ratpack.func.Block;
import ratpack.func.Factory;

public abstract class Exceptions {
    public static RuntimeException uncheck(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof RuntimeException) {
            return (RuntimeException)throwable;
        }
        if (throwable instanceof IOException) {
            throw new UncheckedIOException((IOException)throwable);
        }
        return new UncheckedException(throwable);
    }

    public static Exception toException(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        if (throwable instanceof Exception) {
            return (Exception)throwable;
        }
        return new UncheckedException(throwable);
    }

    public static void throwIfError(Throwable throwable) {
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    public static <T> T uncheck(Factory<T> factory) {
        try {
            return (T)factory.create();
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    public static void uncheck(Block action) {
        try {
            action.execute();
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    public static <T> void uncheck(T input, Action<T> action) {
        try {
            action.execute(input);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }

    public static <T, U> void uncheck(T input1, U input2, BiAction<T, U> action) {
        try {
            action.execute(input1, input2);
        }
        catch (Exception e) {
            throw Exceptions.uncheck(e);
        }
    }
}

