/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import com.google.common.base.Throwables;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import groovy.text.markup.MarkupTemplateEngine;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Path;
import java.util.concurrent.ExecutionException;
import ratpack.util.Exceptions;

public class CachingTemplateResolver
extends MarkupTemplateEngine.DefaultTemplateResolver {
    private final LoadingCache<String, URL> urlCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, URL>(){

        public URL load(String key) throws Exception {
            return CachingTemplateResolver.this.doLoad(key);
        }
    });
    private final Path templatesDir;

    private URL doLoad(String key) throws MalformedURLException {
        return this.templatesDir.resolve(key).toUri().toURL();
    }

    public CachingTemplateResolver(Path templatesDir) {
        this.templatesDir = templatesDir;
    }

    public URL resolveTemplate(String templatePath) throws IOException {
        try {
            return (URL)this.urlCache.get((Object)templatePath);
        }
        catch (ExecutionException e) {
            Throwables.propagateIfInstanceOf((Throwable)e, IOException.class);
            throw Exceptions.uncheck((Throwable)e);
        }
    }
}

