/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import org.codehaus.groovy.control.CompilationFailedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ratpack.groovy.script.internal.ScriptEngine;
import ratpack.groovy.template.internal.CompiledTextTemplate;
import ratpack.groovy.template.internal.DefaultTextTemplateScript;
import ratpack.groovy.template.internal.InvalidTemplateException;
import ratpack.groovy.template.internal.TextTemplateParser;

public class TextTemplateCompiler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ByteBufAllocator byteBufAllocator;
    private boolean verbose;
    private final TextTemplateParser parser = new TextTemplateParser();
    private final ScriptEngine<DefaultTextTemplateScript> scriptEngine;

    public TextTemplateCompiler(ScriptEngine<DefaultTextTemplateScript> scriptEngine, ByteBufAllocator byteBufAllocator) {
        this(scriptEngine, false, byteBufAllocator);
    }

    public TextTemplateCompiler(ScriptEngine<DefaultTextTemplateScript> scriptEngine, boolean verbose, ByteBufAllocator byteBufAllocator) {
        this.scriptEngine = scriptEngine;
        this.verbose = verbose;
        this.byteBufAllocator = byteBufAllocator;
    }

    public CompiledTextTemplate compile(ByteBuf templateSource, String name) throws CompilationFailedException, IOException {
        ByteBuf scriptSource = this.byteBufAllocator.buffer(templateSource.capacity());
        this.parser.parse(templateSource, scriptSource);
        String scriptSourceString = scriptSource.toString(CharsetUtil.UTF_8);
        scriptSource.release();
        if (this.verbose && this.logger.isInfoEnabled()) {
            this.logger.info("\n-- script source --\n" + scriptSourceString + "\n-- script end --\n");
        }
        try {
            Class<DefaultTextTemplateScript> scriptClass = this.scriptEngine.compile(name, scriptSourceString);
            return new CompiledTextTemplate(name, scriptClass);
        }
        catch (Exception e) {
            throw new InvalidTemplateException(name, "compilation failure", e);
        }
    }
}

