/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.handling;

import ratpack.func.Action;
import ratpack.groovy.handling.GroovyChain;
import ratpack.handling.Chain;
import ratpack.handling.Handler;
import ratpack.registry.Registry;
import ratpack.server.ServerConfig;

public abstract class GroovyChainAction
implements GroovyChain,
Action<Chain> {
    private final ThreadLocal<GroovyChain> delegate = new ThreadLocal();

    public abstract void execute() throws Exception;

    public final void execute(Chain chain) throws Exception {
        try {
            this.delegate.set(GroovyChain.from(chain));
            this.execute();
        }
        finally {
            this.delegate.remove();
        }
    }

    private GroovyChain getDelegate() {
        GroovyChain delegate = this.delegate.get();
        if (delegate == null) {
            throw new IllegalStateException("delegate requested outside of execute");
        }
        return delegate;
    }

    @Override
    public GroovyChain all(Handler handler) {
        return this.getDelegate().all(handler);
    }

    public ServerConfig getServerConfig() {
        return this.getDelegate().getServerConfig();
    }

    public Registry getRegistry() throws IllegalStateException {
        return this.getDelegate().getRegistry();
    }
}

