/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.handling.internal;

import groovy.lang.Closure;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import ratpack.groovy.handling.GroovyContext;
import ratpack.groovy.internal.ClosureInvoker;
import ratpack.groovy.internal.ClosureUtil;
import ratpack.handling.Context;
import ratpack.handling.internal.DescribingHandler;
import ratpack.registry.Registry;

public class ClosureBackedHandler
implements DescribingHandler {
    private final ClosureInvoker<?, GroovyContext> invoker;

    public ClosureBackedHandler(Closure<?> closure) {
        this.invoker = new ClosureInvoker(closure);
    }

    public void handle(Context context) {
        this.invoker.invoke((Registry)context, GroovyContext.from(context), 1);
    }

    public void describeTo(StringBuilder stringBuilder) {
        block5: {
            ClosureUtil.SourceInfo sourceInfo = ClosureUtil.getSourceInfo(this.invoker.getClosure());
            if (sourceInfo == null) {
                ClassPool pool = ClassPool.getDefault();
                try {
                    CtClass ctClass = pool.get(this.invoker.getClosure().getClass().getName());
                    CtMethod ctMethod = ctClass.getDeclaredMethod("doCall");
                    int lineNumber = ctMethod.getMethodInfo().getLineNumber(0);
                    ClassFile classFile = ctClass.getClassFile();
                    String sourceFile = classFile.getSourceFile();
                    if (lineNumber != -1 && sourceFile != null) {
                        stringBuilder.append("closure at line ").append(lineNumber).append(" of ").append(sourceFile);
                        break block5;
                    }
                    stringBuilder.append("closure ").append(this.invoker.getClosure().getClass().getName());
                }
                catch (NotFoundException e) {
                    stringBuilder.append(this.invoker.getClosure().getClass().getName());
                }
            } else {
                stringBuilder.append("closure at line ").append(sourceInfo.getLineNumber()).append(" of ").append(sourceInfo.getUri());
            }
        }
    }
}

