/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.internal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.reflect.TypeToken;
import groovy.lang.Closure;
import java.util.Collections;
import java.util.List;
import ratpack.func.Action;
import ratpack.handling.internal.Extractions;
import ratpack.registry.Registry;
import ratpack.registry.internal.TypeCaching;

public class ClosureInvoker<T, D> {
    private final Closure<T> closure;
    private final List<TypeToken<?>> parameterTypes;
    private final boolean hasDefaultParam;

    public ClosureInvoker(Closure<? extends T> closure) {
        this.closure = (Closure)closure.clone();
        this.hasDefaultParam = closure.getMaximumNumberOfParameters() > 0;
        closure.setDelegate(null);
        this.parameterTypes = ClosureInvoker.retrieveParameterTypes(this.closure);
    }

    public Closure<T> getClosure() {
        return this.closure;
    }

    public T invoke(Registry registry, D delegate, int resolveStrategy) {
        Closure clone = (Closure)this.closure.clone();
        clone.setDelegate(delegate);
        clone.setResolveStrategy(resolveStrategy);
        if (this.parameterTypes.isEmpty()) {
            if (this.hasDefaultParam) {
                return (T)clone.call(delegate);
            }
            return (T)clone.call();
        }
        Object[] services = Extractions.extract(this.parameterTypes, (Registry)registry);
        return (T)clone.call(services);
    }

    public Action<D> toAction(Registry registry, int resolveStrategy) {
        return delegate -> this.invoke(registry, delegate, resolveStrategy);
    }

    private static List<TypeToken<?>> retrieveParameterTypes(Closure<?> closure) {
        Object[] parameterTypes = closure.getParameterTypes();
        if (parameterTypes.length == 1 && parameterTypes[0].equals(Object.class)) {
            return Collections.emptyList();
        }
        for (Object clazz : parameterTypes) {
            if (!((Class)clazz).isArray()) continue;
            throw new IllegalStateException("Closure parameters cannot be array types (type: " + ((Class)clazz).getName() + ", closure: " + closure.getClass().getName() + ")");
        }
        return Lists.transform((List)ImmutableList.copyOf((Object[])parameterTypes), TypeCaching::typeToken);
    }
}

