/*
 * Decompiled with CFR 0.152.
 */
package ratpack.groovy.template.internal;

import io.netty.buffer.ByteBuf;
import java.util.Map;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import ratpack.groovy.template.internal.DefaultTextTemplateScript;
import ratpack.groovy.template.internal.InvalidTemplateException;
import ratpack.groovy.template.internal.MapBackedTextTemplateModel;
import ratpack.groovy.template.internal.NestedRenderer;

public class CompiledTextTemplate {
    private final Class<DefaultTextTemplateScript> templateClass;
    private final String templateName;

    public CompiledTextTemplate(String templateName, Class<DefaultTextTemplateScript> templateClass) {
        this.templateName = templateName;
        this.templateClass = templateClass;
    }

    void execute(Map<String, ?> model, ByteBuf buffer, NestedRenderer nestedRenderer) {
        Map<String, Object> modelTyped = model;
        MapBackedTextTemplateModel templateModel = new MapBackedTextTemplateModel(modelTyped);
        DefaultTextTemplateScript script = (DefaultTextTemplateScript)DefaultGroovyMethods.newInstance(this.templateClass, (Object[])new Object[]{templateModel, buffer, nestedRenderer});
        try {
            script.run();
        }
        catch (Exception e) {
            if (e instanceof InvalidTemplateException) {
                throw (InvalidTemplateException)e;
            }
            throw new InvalidTemplateException(this.templateName, "template execution failed", e);
        }
    }
}

