/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl;

import io.reactiverse.vertx.maven.plugin.components.ManifestCustomizerService;
import io.reactiverse.vertx.maven.plugin.model.ExtraManifestKeys;
import io.reactiverse.vertx.maven.plugin.mojos.AbstractVertxMojo;
import io.reactiverse.vertx.maven.plugin.utils.ScmSpy;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.ScmException;
import org.codehaus.plexus.component.annotations.Component;

@Component(role=ManifestCustomizerService.class, hint="scm")
public class SCMManifestCustomizer
implements ManifestCustomizerService {
    @Override
    public Map<String, String> getEntries(AbstractVertxMojo mojo, MavenProject project) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        Scm scm = project.getScm();
        if (mojo.skipScmMetadata() || scm == null) {
            return attributes;
        }
        String connectionUrl = SCMManifestCustomizer.addAttributesFromProject(attributes, scm);
        if (mojo.getScmManager() != null && connectionUrl != null) {
            try {
                SCMManifestCustomizer.addAttributeFromScmManager(mojo, attributes, connectionUrl, project.getBasedir());
            }
            catch (Exception e) {
                mojo.getLog().warn((CharSequence)("Error while getting SCM Metadata `" + e.getMessage() + "`"));
                mojo.getLog().warn((CharSequence)"SCM metadata ignored");
                mojo.getLog().debug((Throwable)e);
            }
        }
        return attributes;
    }

    private static void addAttributeFromScmManager(AbstractVertxMojo mojo, Map<String, String> attributes, String connectionUrl, File baseDir) throws IOException, ScmException {
        ScmSpy scmSpy = new ScmSpy(mojo.getScmManager());
        Map<ExtraManifestKeys, String> scmChangeLogMap = scmSpy.getChangeLog(connectionUrl, baseDir);
        scmChangeLogMap.forEach((key, value) -> attributes.put(key.header(), (String)value));
    }

    private static String addAttributesFromProject(Map<String, String> attributes, Scm scm) {
        String connectionUrl;
        String string = connectionUrl = scm.getConnection() == null ? scm.getDeveloperConnection() : scm.getConnection();
        if (scm.getUrl() != null) {
            attributes.put(ExtraManifestKeys.SCM_URL.header(), scm.getUrl());
        }
        if (scm.getTag() != null) {
            attributes.put(ExtraManifestKeys.SCM_TAG.header(), scm.getTag());
        }
        return connectionUrl;
    }
}

