/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl.merge;

import com.google.common.base.Joiner;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergeResult;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergingStrategy;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.TextResult;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.apache.maven.project.MavenProject;
import org.jboss.shrinkwrap.api.asset.Asset;

public class GroovyExtensionStrategy
implements MergingStrategy {
    @Override
    public MergeResult merge(MavenProject project, Asset local, List<Asset> deps) {
        ArrayList<String> extensionClassesList = new ArrayList<String>();
        ArrayList<String> staticExtensionClassesList = new ArrayList<String>();
        ArrayList<Properties> all = new ArrayList<Properties>();
        all.add(GroovyExtensionStrategy.asProperties(local));
        if (deps != null) {
            deps.forEach(s -> all.add(GroovyExtensionStrategy.asProperties(s)));
        }
        for (Properties properties : all) {
            String staticExtensionClasses = properties.getProperty("staticExtensionClasses", "").trim();
            String extensionClasses = properties.getProperty("extensionClasses", "").trim();
            if (extensionClasses.length() > 0) {
                GroovyExtensionStrategy.append(extensionClasses, extensionClassesList);
            }
            if (staticExtensionClasses.length() <= 0) continue;
            GroovyExtensionStrategy.append(staticExtensionClasses, staticExtensionClassesList);
        }
        ArrayList<String> desc = new ArrayList<String>();
        desc.add("moduleName=" + project.getArtifactId());
        desc.add("moduleVersion=" + project.getVersion());
        if (!extensionClassesList.isEmpty()) {
            desc.add("extensionClasses=" + GroovyExtensionStrategy.join(extensionClassesList));
        }
        if (!staticExtensionClassesList.isEmpty()) {
            desc.add("staticExtensionClasses=" + GroovyExtensionStrategy.join(staticExtensionClassesList));
        }
        return new TextResult(desc);
    }

    private static void append(String entry, List<String> list) {
        if (entry != null) {
            Collections.addAll(list, entry.split("\\s*,\\s*"));
        }
    }

    private static String join(List<String> strings) {
        return Joiner.on((String)",").join(strings);
    }

    private static Properties asProperties(Asset asset) {
        Properties properties = new Properties();
        try (InputStream is = asset.openStream();){
            properties.load(is);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return properties;
    }
}

