/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.components.impl.merge;

import io.reactiverse.vertx.maven.plugin.components.impl.merge.BinaryResult;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergeResult;
import io.reactiverse.vertx.maven.plugin.components.impl.merge.MergingStrategy;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.core.config.plugins.processor.PluginCache;
import org.apache.maven.project.MavenProject;
import org.jboss.shrinkwrap.api.asset.Asset;

public class Log4j2PluginsStrategy
implements MergingStrategy {
    @Override
    public MergeResult merge(MavenProject project, Asset local, List<Asset> deps) {
        ArrayList<File> files = new ArrayList<File>(1 + (deps == null ? 0 : deps.size()));
        try {
            if (local != null) {
                files.add(this.copy(local));
            }
            if (deps != null) {
                for (Asset dep : deps) {
                    files.add(this.copy(dep));
                }
            }
            ArrayList<URL> urls = new ArrayList<URL>(files.size());
            for (File resource : files) {
                urls.add(resource.toURI().toURL());
            }
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            PluginCache cache = new PluginCache();
            cache.loadCacheFiles(Collections.enumeration(urls));
            cache.writeCache((OutputStream)baos);
            BinaryResult binaryResult = new BinaryResult(baos.toByteArray());
            return binaryResult;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            files.forEach(File::delete);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private File copy(Asset asset) {
        try (InputStream is = asset.openStream();){
            File tempFile = File.createTempFile(Log4j2PluginsStrategy.class.getSimpleName(), null);
            FileUtils.copyInputStreamToFile((InputStream)is, (File)tempFile);
            File file = tempFile;
            return file;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

