/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.DependencySet;
import io.reactiverse.vertx.maven.plugin.mojos.FileItem;
import io.reactiverse.vertx.maven.plugin.mojos.FileSet;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class Archive {
    private String outputFileName;
    private Map<String, String> manifest = new LinkedHashMap<String, String>();
    private List<FileSet> fileSets = new ArrayList<FileSet>();
    private List<FileItem> files = new ArrayList<FileItem>();
    private List<DependencySet> dependencySets = new ArrayList<DependencySet>();
    private boolean includeClasses = true;
    private List<String> fileCombinationPatterns = new ArrayList<String>();

    public Archive addDependencySet(DependencySet dependencySet) {
        this.getDependencySets().add(dependencySet);
        return this;
    }

    public Archive addFile(FileItem fileItem) {
        this.getFiles().add(fileItem);
        return this;
    }

    public Archive addFileSet(FileSet fileSet) {
        this.getFileSets().add(fileSet);
        return this;
    }

    public List<DependencySet> getDependencySets() {
        return this.dependencySets;
    }

    public List<FileSet> getFileSets() {
        return this.fileSets;
    }

    public List<FileItem> getFiles() {
        return this.files;
    }

    public Archive removeDependencySet(DependencySet dependencySet) {
        this.getDependencySets().remove(dependencySet);
        return this;
    }

    public Archive removeFile(FileItem fileItem) {
        this.getFiles().remove(fileItem);
        return this;
    }

    public Archive removeFileSet(FileSet fileSet) {
        this.getFileSets().remove(fileSet);
        return this;
    }

    public Archive setDependencySets(List<DependencySet> dependencySets) {
        this.dependencySets = Objects.requireNonNull(dependencySets);
        return this;
    }

    public Archive setFileSets(List<FileSet> fileSets) {
        this.fileSets = Objects.requireNonNull(fileSets);
        return this;
    }

    public Archive setFiles(List<FileItem> files) {
        this.files = files;
        return this;
    }

    public String getOutputFileName() {
        return this.outputFileName;
    }

    public Archive setOutputFileName(String outputFileName) {
        this.outputFileName = outputFileName;
        return this;
    }

    public Map<String, String> getManifest() {
        return this.manifest;
    }

    public Archive setManifest(Map<String, String> manifest) {
        this.manifest = manifest;
        return this;
    }

    public boolean isIncludeClasses() {
        return this.includeClasses;
    }

    public Archive setIncludeClasses(boolean includeClasses) {
        this.includeClasses = includeClasses;
        return this;
    }

    public Archive addFileCombinationPattern(String pattern) {
        this.fileCombinationPatterns.add(Objects.requireNonNull(pattern));
        if (!pattern.startsWith("/")) {
            this.fileCombinationPatterns.add("/" + pattern);
        }
        return this;
    }

    public Archive removeFileCombinationPattern(String pattern) {
        this.fileCombinationPatterns.remove(Objects.requireNonNull(pattern));
        return this;
    }

    public Archive setFileCombinationPatterns(List<String> patterns) {
        Objects.requireNonNull(patterns).forEach(this::addFileCombinationPattern);
        return this;
    }

    public List<String> getFileCombinationPatterns() {
        return this.fileCombinationPatterns;
    }
}

