/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.mojos;

import io.reactiverse.vertx.maven.plugin.mojos.RunMojo;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;

@Mojo(name="debug", threadSafe=true, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class DebugMojo
extends RunMojo {
    @Parameter(property="debug.suspend", defaultValue="false")
    boolean debugSuspend;
    @Parameter(property="debug.port", defaultValue="5005")
    String debugPort;

    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        List<String> debugOptions = this.computeDebugOptions();
        if (this.jvmArgs == null) {
            this.jvmArgs = new ArrayList();
        }
        this.jvmArgs.addAll(debugOptions);
        if (this.redeploy) {
            this.getLog().warn((CharSequence)"Redeployment and Debug cannot be used together - disabling redeployment");
            this.redeploy = false;
        }
        this.getLog().info((CharSequence)("The application will wait for a debugger to attach on debugPort " + this.debugPort));
        if (this.debugSuspend) {
            this.getLog().info((CharSequence)"The application will wait for a debugger to attach");
        }
        super.execute();
    }

    private List<String> computeDebugOptions() {
        String debugger = "-agentlib:jdwp=transport=dt_socket,server=y,suspend=" + (this.debugSuspend ? "y" : "n") + ",address=" + this.debugPort;
        String disableEventLoopchecker = "-Dvertx.options.maxEventLoopExecuteTime=9223372036854775807";
        String disableWorkerchecker = "-Dvertx.options.maxWorkerExecuteTime=9223372036854775807";
        String mark = "-Dvertx.debug=true";
        ArrayList<String> list = new ArrayList<String>();
        list.add(debugger);
        list.add(disableEventLoopchecker);
        list.add(disableWorkerchecker);
        list.add(mark);
        return list;
    }
}

