/*
 * Decompiled with CFR 0.152.
 */
package io.reactiverse.vertx.maven.plugin.utils;

import java.io.File;

public class ExecUtils {
    private static final String[] EXECUTABLE_EXTENSIONS = new String[]{"", ".sh", ".bash", ".exe", ".bat", ".cmd"};

    public static File find(String executable, File ... dirs) {
        if (dirs != null) {
            for (File hint : dirs) {
                File file = ExecUtils.findExecutableInDirectory(executable, hint);
                if (file == null) continue;
                return file;
            }
        }
        return ExecUtils.findExecutableInSystemPath(executable);
    }

    private static File findExecutableInDirectory(String executable, File directory) {
        if (directory == null || !directory.isDirectory()) {
            return null;
        }
        for (String extension : EXECUTABLE_EXTENSIONS) {
            File file = new File(directory, executable + extension);
            if (!file.isFile() || !file.canExecute()) continue;
            return file;
        }
        return null;
    }

    public static File findExecutableInSystemPath(String executable) {
        String[] pathDirs;
        String systemPath = System.getenv("PATH");
        if (systemPath == null) {
            return null;
        }
        for (String pathDir : pathDirs = systemPath.split(File.pathSeparator)) {
            File file;
            File dir = new File(pathDir);
            if (!dir.isDirectory() || (file = ExecUtils.findExecutableInDirectory(executable, dir)) == null) continue;
            return file;
        }
        return null;
    }
}

