/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client;

import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import rx.Subscription;

public class HostConnector<W, R>
implements EventSource<ClientEventListener> {
    private final Host host;
    private final ConnectionProvider<W, R> connectionProvider;
    private final EventSource eventSource;
    private final EventPublisher publisher;
    private final ClientEventListener clientPublisher;

    public HostConnector(Host host, ConnectionProvider<W, R> connectionProvider, EventSource<? extends ClientEventListener> eventSource, EventPublisher publisher, ClientEventListener clientPublisher) {
        this.host = host;
        this.connectionProvider = connectionProvider;
        this.eventSource = eventSource;
        this.publisher = publisher;
        this.clientPublisher = clientPublisher;
    }

    public HostConnector(HostConnector<W, R> source, ConnectionProvider<W, R> connectionProvider) {
        this.connectionProvider = connectionProvider;
        this.host = source.host;
        this.eventSource = source.eventSource;
        this.clientPublisher = source.clientPublisher;
        this.publisher = source.publisher;
    }

    public Host getHost() {
        return this.host;
    }

    public ConnectionProvider<W, R> getConnectionProvider() {
        return this.connectionProvider;
    }

    public ClientEventListener getClientPublisher() {
        return this.clientPublisher;
    }

    public EventPublisher getEventPublisher() {
        return this.publisher;
    }

    @Override
    public Subscription subscribe(ClientEventListener listener) {
        return this.eventSource.subscribe(listener);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof HostConnector)) {
            return false;
        }
        HostConnector that = (HostConnector)o;
        if (this.host != null ? !this.host.equals(that.host) : that.host != null) {
            return false;
        }
        if (this.connectionProvider != null ? !this.connectionProvider.equals(that.connectionProvider) : that.connectionProvider != null) {
            return false;
        }
        if (this.eventSource != null ? !this.eventSource.equals(that.eventSource) : that.eventSource != null) {
            return false;
        }
        if (this.publisher != null ? !this.publisher.equals(that.publisher) : that.publisher != null) {
            return false;
        }
        return this.clientPublisher != null ? this.clientPublisher.equals(that.clientPublisher) : that.clientPublisher == null;
    }

    public int hashCode() {
        int result = this.host != null ? this.host.hashCode() : 0;
        result = 31 * result + (this.connectionProvider != null ? this.connectionProvider.hashCode() : 0);
        result = 31 * result + (this.eventSource != null ? this.eventSource.hashCode() : 0);
        result = 31 * result + (this.publisher != null ? this.publisher.hashCode() : 0);
        result = 31 * result + (this.clientPublisher != null ? this.clientPublisher.hashCode() : 0);
        return result;
    }
}

