/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.client.loadbalancer;

import io.reactivex.netty.channel.Connection;
import io.reactivex.netty.client.ConnectionProvider;
import io.reactivex.netty.client.Host;
import io.reactivex.netty.client.HostConnector;
import io.reactivex.netty.client.events.ClientEventListener;
import io.reactivex.netty.client.loadbalancer.HostHolder;
import io.reactivex.netty.client.loadbalancer.LoadBalancingStrategy;
import io.reactivex.netty.client.loadbalancer.NoHostsAvailableException;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import rx.Observable;

public abstract class AbstractP2CStrategy<W, R, L extends ClientEventListener>
implements LoadBalancingStrategy<W, R> {
    @Override
    public ConnectionProvider<W, R> newStrategy(final List<HostHolder<W, R>> hosts) {
        this.newHostsList(hosts.size());
        return new ConnectionProvider<W, R>(){

            @Override
            public Observable<Connection<R, W>> newConnectionRequest() {
                HostHolder selected = null;
                if (hosts.isEmpty()) {
                    AbstractP2CStrategy.this.noUsableHostsFound();
                    return Observable.error((Throwable)NoHostsAvailableException.EMPTY_INSTANCE);
                }
                if (hosts.size() == 1) {
                    HostHolder holder = (HostHolder)hosts.get(0);
                    ClientEventListener eventListener = holder.getEventListener();
                    double weight = AbstractP2CStrategy.this.getWeight(eventListener);
                    if (AbstractP2CStrategy.this.isUnusable(weight)) {
                        AbstractP2CStrategy.this.noUsableHostsFound();
                        return Observable.error((Throwable)new NoHostsAvailableException("No usable hosts found."));
                    }
                    selected = holder;
                } else {
                    ThreadLocalRandom rand = ThreadLocalRandom.current();
                    for (int i = 0; i < 5; ++i) {
                        double w2;
                        int pos = rand.nextInt(hosts.size());
                        HostHolder first = (HostHolder)hosts.get(pos);
                        int pos2 = (rand.nextInt(hosts.size() - 1) + pos + 1) % hosts.size();
                        HostHolder second = (HostHolder)hosts.get(pos2);
                        double w1 = AbstractP2CStrategy.this.getWeight(first.getEventListener());
                        if (w1 > (w2 = AbstractP2CStrategy.this.getWeight(second.getEventListener()))) {
                            selected = first;
                            break;
                        }
                        if (w1 < w2) {
                            selected = second;
                            break;
                        }
                        if (!AbstractP2CStrategy.this.isUnusable(w1)) {
                            selected = first;
                            break;
                        }
                        AbstractP2CStrategy.this.foundTwoUnusableHosts();
                    }
                    if (null == selected) {
                        AbstractP2CStrategy.this.noUsableHostsFound();
                        return Observable.error((Throwable)new NoHostsAvailableException("No usable hosts found after 5 tries."));
                    }
                }
                return selected.getConnector().getConnectionProvider().newConnectionRequest();
            }
        };
    }

    protected boolean isUnusable(double weight) {
        return weight < 0.0;
    }

    @Override
    public HostHolder<W, R> toHolder(HostConnector<W, R> connector) {
        return new HostHolder<W, R>(connector, (ClientEventListener)this.newListener(connector.getHost()));
    }

    protected abstract L newListener(Host var1);

    protected abstract double getWeight(L var1);

    protected void noUsableHostsFound() {
    }

    protected void foundTwoUnusableHosts() {
    }

    protected void newHostsList(int size) {
    }
}

