/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.netty.events;

import io.reactivex.netty.RxNetty;
import io.reactivex.netty.events.EventListener;
import io.reactivex.netty.events.EventPublisher;
import io.reactivex.netty.events.EventSource;
import io.reactivex.netty.events.ListenerInvocationException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscription;
import rx.exceptions.Exceptions;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.functions.Action2;
import rx.functions.Action3;
import rx.functions.Action4;
import rx.functions.Action5;
import rx.subscriptions.CompositeSubscription;
import rx.subscriptions.Subscriptions;

public final class ListenersHolder<T extends EventListener>
implements EventSource<T>,
EventPublisher {
    private static final Logger logger = LoggerFactory.getLogger(ListenersHolder.class);
    private final CopyOnWriteArraySet<ListenerHolder<T>> listeners;

    public ListenersHolder() {
        this.listeners = new CopyOnWriteArraySet();
    }

    public ListenersHolder(ListenersHolder<T> toCopy) {
        this.listeners = new CopyOnWriteArraySet<ListenerHolder<T>>(toCopy.listeners);
        for (final ListenerHolder<T> holder : this.listeners) {
            ((ListenerHolder)holder).subscription.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    ListenersHolder.this.listeners.remove(holder);
                }
            }));
        }
    }

    @Override
    public Subscription subscribe(T listener) {
        CompositeSubscription cs = new CompositeSubscription();
        ListenerHolder.configureRemoval(cs, listener, this.listeners);
        ListenerHolder<T> holder = new ListenerHolder<T>(listener, cs);
        this.listeners.add(holder);
        return cs;
    }

    @Override
    public boolean publishingEnabled() {
        return !RxNetty.isEventPublishingDisabled() && !this.listeners.isEmpty();
    }

    public void dispose() {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            try {
                listener.onCompleted();
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            throw exception;
        }
    }

    public void invokeListeners(Action1<T> invocationAction) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    public void invokeListeners(Action3<T, Long, TimeUnit> invocationAction, long duration, TimeUnit timeUnit) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate, (Object)duration, (Object)timeUnit);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    public void invokeListeners(Action4<T, Long, TimeUnit, Throwable> invocationAction, long duration, TimeUnit timeUnit, Throwable throwable) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate, (Object)duration, (Object)timeUnit, (Object)throwable);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    public <A> void invokeListeners(Action4<T, Long, TimeUnit, A> invocationAction, long duration, TimeUnit timeUnit, A arg) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate, (Object)duration, (Object)timeUnit, arg);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    public <A> void invokeListeners(Action5<T, Long, TimeUnit, Throwable, A> invocationAction, long duration, TimeUnit timeUnit, Throwable throwable, A arg) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate, (Object)duration, (Object)timeUnit, (Object)throwable, arg);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    public <A> void invokeListeners(Action2<T, A> invocationAction, A arg) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate, arg);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    public <A> void invokeListeners(Action3<T, Throwable, A> invocationAction, Throwable throwable, A arg) {
        ListenerInvocationException exception = null;
        for (ListenerHolder<T> listener : this.listeners) {
            if (((ListenerHolder)listener).subscription.isUnsubscribed()) continue;
            try {
                invocationAction.call((Object)((ListenerHolder)listener).delegate, (Object)throwable, arg);
            }
            catch (Throwable e) {
                exception = this.handleListenerError(exception, listener, e);
            }
        }
        if (null != exception) {
            exception.finish();
            logger.error("Error occured while invoking event listeners.", (Throwable)exception);
        }
    }

    private ListenerInvocationException handleListenerError(ListenerInvocationException exception, ListenerHolder<T> listener, Throwable e) {
        Exceptions.throwIfFatal((Throwable)e);
        if (null == exception) {
            exception = new ListenerInvocationException();
        }
        exception.addException(((ListenerHolder)listener).delegate, e);
        return exception;
    }

    public ListenersHolder<T> copy() {
        return new ListenersHolder<T>(this);
    }

    Collection<T> getAllListeners() {
        ArrayList<EventListener> toReturn = new ArrayList<EventListener>();
        for (ListenerHolder<T> listener : this.listeners) {
            toReturn.add(((ListenerHolder)listener).delegate);
        }
        return toReturn;
    }

    CopyOnWriteArraySet<ListenerHolder<T>> getActualListenersList() {
        return this.listeners;
    }

    public void subscribeAllTo(EventSource<T> lazySource) {
        for (ListenerHolder<T> listener : this.listeners) {
            ((ListenerHolder)listener).subscription.add(lazySource.subscribe(((ListenerHolder)listener).delegate));
        }
    }

    private static class ListenerHolder<T extends EventListener>
    implements EventListener {
        private static final CompositeSubscription EMPTY_SUB_FOR_REMOVAL = new CompositeSubscription();
        private final T delegate;
        private final CompositeSubscription subscription;

        public ListenerHolder(T delegate, CompositeSubscription subscription) {
            this.delegate = delegate;
            this.subscription = subscription;
        }

        @Override
        public void onCompleted() {
            if (!this.subscription.isUnsubscribed()) {
                try {
                    this.delegate.onCompleted();
                }
                finally {
                    this.subscription.unsubscribe();
                }
            }
        }

        @Override
        public void onCustomEvent(Object event) {
        }

        @Override
        public void onCustomEvent(Object event, long duration, TimeUnit timeUnit) {
        }

        @Override
        public void onCustomEvent(Object event, Throwable throwable) {
        }

        @Override
        public void onCustomEvent(Object event, long duration, TimeUnit timeUnit, Throwable throwable) {
        }

        public static <X extends EventListener> ListenerHolder<X> forRemoval(X listenerToRemove) {
            return new ListenerHolder<X>(listenerToRemove, EMPTY_SUB_FOR_REMOVAL);
        }

        public static <X extends EventListener> void configureRemoval(CompositeSubscription cs, final X listenerToRemove, final CopyOnWriteArraySet<ListenerHolder<X>> removeFrom) {
            cs.add(Subscriptions.create((Action0)new Action0(){

                public void call() {
                    removeFrom.remove(ListenerHolder.forRemoval(listenerToRemove));
                }
            }));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ListenerHolder)) {
                return false;
            }
            ListenerHolder that = (ListenerHolder)o;
            return this.delegate.equals(that.delegate);
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }
    }
}

