/*
 * Decompiled with CFR 0.152.
 */
package restx.servlet;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import restx.AbstractRequest;
import restx.HttpSettings;

public class HttpServletRestxRequest
extends AbstractRequest {
    private final HttpServletRequest request;
    private BufferedInputStream bufferedInputStream;
    private ImmutableMap<String, ImmutableList<String>> queryParams;

    public HttpServletRestxRequest(HttpSettings httpSettings, HttpServletRequest request) {
        super(httpSettings);
        this.request = request;
    }

    public String getLocalClientAddress() {
        return this.request.getRemoteAddr();
    }

    protected String getBaseApiPath() {
        return this.request.getContextPath() + this.request.getServletPath();
    }

    protected String getLocalScheme() {
        return this.request.getScheme();
    }

    public String getRestxPath() {
        return this.request.getRequestURI().substring(this.getBaseApiPath().length());
    }

    public String getRestxUri() {
        if (this.request.getQueryString() == null) {
            return this.getRestxPath();
        }
        return this.getRestxPath() + "?" + this.request.getQueryString();
    }

    public Optional<String> getQueryParam(String param) {
        return Optional.fromNullable((Object)this.request.getParameter(param));
    }

    public List<String> getQueryParams(String param) {
        return Lists.newArrayList((Object[])this.request.getParameterValues(param));
    }

    public ImmutableMap<String, ImmutableList<String>> getQueryParams() {
        if (this.queryParams == null) {
            Map<String, String[]> parameterMap = this.getParameterMap();
            ImmutableMap.Builder paramsBuilder = ImmutableMap.builder();
            for (Map.Entry<String, String[]> entry : parameterMap.entrySet()) {
                paramsBuilder.put((Object)entry.getKey(), (Object)ImmutableList.copyOf((Object[])entry.getValue()));
            }
            this.queryParams = paramsBuilder.build();
        }
        return this.queryParams;
    }

    protected Map<String, String[]> getParameterMap() {
        return this.request.getParameterMap();
    }

    public InputStream getContentStream() throws IOException {
        if (this.bufferedInputStream == null) {
            this.bufferedInputStream = new BufferedInputStream((InputStream)this.request.getInputStream()){

                @Override
                public void close() throws IOException {
                }
            };
            this.bufferedInputStream.mark(10240);
        }
        return this.bufferedInputStream;
    }

    public void closeContentStream() throws IOException {
        this.bufferedInputStream.close();
    }

    public String getHttpMethod() {
        return this.request.getMethod();
    }

    public ImmutableMap<String, String> getCookiesMap() {
        LinkedHashMap cookies = Maps.newLinkedHashMap();
        Cookie[] requestCookies = this.request.getCookies();
        if (requestCookies != null) {
            for (int i = 0; i < requestCookies.length; ++i) {
                Cookie cookie = requestCookies[i];
                cookies.put(cookie.getName(), cookie.getValue());
            }
        }
        return ImmutableMap.copyOf((Map)cookies);
    }

    public Optional<String> getCookieValue(String cookieName) {
        return Optional.fromNullable((Object)HttpServletRestxRequest.getCookieValue(this.request.getCookies(), cookieName));
    }

    public boolean isPersistentCookie(String cookie) {
        Cookie c = HttpServletRestxRequest.getCookie(this.request.getCookies(), cookie);
        return c == null ? false : c.getMaxAge() > 0;
    }

    private static String getCookieValue(Cookie[] cookies, String cookieName) {
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    static Cookie getCookie(Cookie[] cookies, String cookieName) {
        if (cookies == null) {
            return null;
        }
        for (int i = 0; i < cookies.length; ++i) {
            Cookie cookie = cookies[i];
            if (!cookieName.equals(cookie.getName())) continue;
            return cookie;
        }
        return null;
    }

    public Optional<String> getHeader(String headerName) {
        return Optional.fromNullable((Object)this.request.getHeader(headerName));
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public <T> T unwrap(Class<T> clazz) {
        if (clazz == HttpServletRequest.class || clazz == ServletRequest.class) {
            return (T)this.request;
        }
        throw new IllegalArgumentException("underlying implementation is HttpServletRequest, not " + clazz.getName());
    }

    public Locale getLocale() {
        return this.request.getLocale();
    }

    public ImmutableList<Locale> getLocales() {
        return ImmutableList.copyOf((Iterator)Iterators.forEnumeration((Enumeration)this.request.getLocales()));
    }
}

