/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.collection.IntObjectMap;
import io.rsocket.DuplexConnection;
import io.rsocket.Payload;
import io.rsocket.RSocket;
import io.rsocket.StreamIdSupplier;
import io.rsocket.exceptions.ConnectionErrorException;
import io.rsocket.exceptions.Exceptions;
import io.rsocket.frame.CancelFrameFlyweight;
import io.rsocket.frame.ErrorFrameFlyweight;
import io.rsocket.frame.FrameHeaderFlyweight;
import io.rsocket.frame.FrameType;
import io.rsocket.frame.MetadataPushFrameFlyweight;
import io.rsocket.frame.PayloadFrameFlyweight;
import io.rsocket.frame.RequestChannelFrameFlyweight;
import io.rsocket.frame.RequestFireAndForgetFrameFlyweight;
import io.rsocket.frame.RequestNFrameFlyweight;
import io.rsocket.frame.RequestResponseFrameFlyweight;
import io.rsocket.frame.RequestStreamFrameFlyweight;
import io.rsocket.frame.decoder.PayloadDecoder;
import io.rsocket.internal.RateLimitableRequestPublisher;
import io.rsocket.internal.SynchronizedIntObjectHashMap;
import io.rsocket.internal.UnboundedProcessor;
import io.rsocket.internal.UnicastMonoEmpty;
import io.rsocket.internal.UnicastMonoProcessor;
import io.rsocket.keepalive.KeepAliveFramesAcceptor;
import io.rsocket.keepalive.KeepAliveHandler;
import io.rsocket.keepalive.KeepAliveSupport;
import io.rsocket.lease.RequesterLeaseHandler;
import io.rsocket.util.MonoLifecycleHandler;
import java.nio.channels.ClosedChannelException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import java.util.function.LongConsumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.reactivestreams.Processor;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.BaseSubscriber;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.SignalType;
import reactor.core.publisher.UnicastProcessor;
import reactor.util.concurrent.Queues;

class RSocketRequester
implements RSocket {
    private static final AtomicReferenceFieldUpdater<RSocketRequester, Throwable> TERMINATION_ERROR = AtomicReferenceFieldUpdater.newUpdater(RSocketRequester.class, Throwable.class, "terminationError");
    private static final Exception CLOSED_CHANNEL_EXCEPTION = new ClosedChannelException();
    private final DuplexConnection connection;
    private final PayloadDecoder payloadDecoder;
    private final Consumer<Throwable> errorConsumer;
    private final StreamIdSupplier streamIdSupplier;
    private final IntObjectMap<RateLimitableRequestPublisher> senders;
    private final IntObjectMap<Processor<Payload, Payload>> receivers;
    private final UnboundedProcessor<ByteBuf> sendProcessor;
    private final RequesterLeaseHandler leaseHandler;
    private final ByteBufAllocator allocator;
    private final KeepAliveFramesAcceptor keepAliveFramesAcceptor;
    private volatile Throwable terminationError;

    RSocketRequester(ByteBufAllocator allocator, DuplexConnection connection, PayloadDecoder payloadDecoder, Consumer<Throwable> errorConsumer, StreamIdSupplier streamIdSupplier, int keepAliveTickPeriod, int keepAliveAckTimeout, @Nullable KeepAliveHandler keepAliveHandler, RequesterLeaseHandler leaseHandler) {
        this.allocator = allocator;
        this.connection = connection;
        this.payloadDecoder = payloadDecoder;
        this.errorConsumer = errorConsumer;
        this.streamIdSupplier = streamIdSupplier;
        this.leaseHandler = leaseHandler;
        this.senders = new SynchronizedIntObjectHashMap<RateLimitableRequestPublisher>();
        this.receivers = new SynchronizedIntObjectHashMap<Processor<Payload, Payload>>();
        this.sendProcessor = new UnboundedProcessor();
        connection.onClose().doFinally(signalType -> this.tryTerminateOnConnectionClose()).subscribe(null, errorConsumer);
        connection.send((Publisher<ByteBuf>)this.sendProcessor).subscribe(null, this::handleSendProcessorError);
        connection.receive().subscribe(this::handleIncomingFrames, errorConsumer);
        if (keepAliveTickPeriod != 0 && keepAliveHandler != null) {
            KeepAliveSupport.ClientKeepAliveSupport keepAliveSupport = new KeepAliveSupport.ClientKeepAliveSupport(allocator, keepAliveTickPeriod, keepAliveAckTimeout);
            this.keepAliveFramesAcceptor = keepAliveHandler.start(keepAliveSupport, this.sendProcessor::onNext, this::tryTerminateOnKeepAlive);
        } else {
            this.keepAliveFramesAcceptor = null;
        }
    }

    @Override
    public Mono<Void> fireAndForget(Payload payload) {
        return this.handleFireAndForget(payload);
    }

    @Override
    public Mono<Payload> requestResponse(Payload payload) {
        return this.handleRequestResponse(payload);
    }

    @Override
    public Flux<Payload> requestStream(Payload payload) {
        return this.handleRequestStream(payload);
    }

    @Override
    public Flux<Payload> requestChannel(Publisher<Payload> payloads) {
        return this.handleChannel((Flux<Payload>)Flux.from(payloads));
    }

    @Override
    public Mono<Void> metadataPush(Payload payload) {
        return this.handleMetadataPush(payload);
    }

    @Override
    public double availability() {
        return Math.min(this.connection.availability(), this.leaseHandler.availability());
    }

    public void dispose() {
        this.connection.dispose();
    }

    public boolean isDisposed() {
        return this.connection.isDisposed();
    }

    @Override
    public Mono<Void> onClose() {
        return this.connection.onClose();
    }

    private Mono<Void> handleFireAndForget(Payload payload) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            payload.release();
            return Mono.error((Throwable)err);
        }
        int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        return UnicastMonoEmpty.newInstance(() -> {
            ByteBuf requestFrame = RequestFireAndForgetFrameFlyweight.encode(this.allocator, streamId, false, payload.hasMetadata() ? payload.sliceMetadata().retain() : null, payload.sliceData().retain());
            payload.release();
            this.sendProcessor.onNext(requestFrame);
        });
    }

    private Mono<Payload> handleRequestResponse(final Payload payload) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            payload.release();
            return Mono.error((Throwable)err);
        }
        final int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        UnicastMonoProcessor<Payload> receiver = UnicastMonoProcessor.create(new MonoLifecycleHandler<Payload>(){

            @Override
            public void doOnSubscribe() {
                ByteBuf requestFrame = RequestResponseFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, false, payload.sliceMetadata().retain(), payload.sliceData().retain());
                payload.release();
                sendProcessor.onNext(requestFrame);
            }

            @Override
            public void doOnTerminal(@Nonnull SignalType signalType, @Nullable Payload element, @Nullable Throwable e) {
                if (signalType == SignalType.ON_ERROR) {
                    sendProcessor.onNext(ErrorFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, e));
                } else if (signalType == SignalType.CANCEL) {
                    sendProcessor.onNext(CancelFrameFlyweight.encode(RSocketRequester.this.allocator, streamId));
                }
                RSocketRequester.this.removeStreamReceiver(streamId);
            }
        });
        this.receivers.put(streamId, receiver);
        return receiver;
    }

    private Flux<Payload> handleRequestStream(final Payload payload) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            payload.release();
            return Flux.error((Throwable)err);
        }
        final int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final UnicastProcessor receiver = UnicastProcessor.create();
        this.receivers.put(streamId, (Object)receiver);
        return receiver.doOnRequest(new LongConsumer(){
            boolean firstRequest = true;

            @Override
            public void accept(long n) {
                if (this.firstRequest && !receiver.isDisposed()) {
                    this.firstRequest = false;
                    sendProcessor.onNext(RequestStreamFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, false, n, payload.sliceMetadata().retain(), payload.sliceData().retain()));
                    payload.release();
                } else if (RSocketRequester.this.contains(streamId) && !receiver.isDisposed()) {
                    sendProcessor.onNext(RequestNFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, n));
                }
            }
        }).doOnError(t -> {
            if (this.contains(streamId) && !receiver.isDisposed()) {
                sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t));
            }
        }).doOnCancel(() -> {
            if (this.contains(streamId) && !receiver.isDisposed()) {
                sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
            }
        }).doFinally(s -> this.removeStreamReceiver(streamId));
    }

    private Flux<Payload> handleChannel(final Flux<Payload> request) {
        Throwable err = this.checkAvailable();
        if (err != null) {
            return Flux.error((Throwable)err);
        }
        final UnboundedProcessor<ByteBuf> sendProcessor = this.sendProcessor;
        final UnicastProcessor receiver = UnicastProcessor.create();
        final int streamId = this.streamIdSupplier.nextStreamId(this.receivers);
        return receiver.doOnRequest(new LongConsumer(){
            boolean firstRequest = true;

            @Override
            public void accept(final long n) {
                if (this.firstRequest) {
                    this.firstRequest = false;
                    request.transform(f -> {
                        RateLimitableRequestPublisher wrapped = RateLimitableRequestPublisher.wrap(f, Queues.SMALL_BUFFER_SIZE);
                        wrapped.request(1L);
                        RSocketRequester.this.senders.put(streamId, wrapped);
                        RSocketRequester.this.receivers.put(streamId, (Object)receiver);
                        return wrapped;
                    }).subscribe((CoreSubscriber)new BaseSubscriber<Payload>(){
                        boolean firstPayload = true;

                        protected void hookOnNext(Payload payload) {
                            ByteBuf frame;
                            if (this.firstPayload) {
                                this.firstPayload = false;
                                frame = RequestChannelFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, false, false, n, payload.sliceMetadata().retain(), payload.sliceData().retain());
                            } else {
                                frame = PayloadFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, false, false, true, payload);
                            }
                            sendProcessor.onNext(frame);
                            payload.release();
                        }

                        protected void hookOnComplete() {
                            if (RSocketRequester.this.contains(streamId) && !receiver.isDisposed()) {
                                sendProcessor.onNext(PayloadFrameFlyweight.encodeComplete(RSocketRequester.this.allocator, streamId));
                            }
                            if (this.firstPayload) {
                                receiver.onComplete();
                            }
                        }

                        protected void hookOnError(Throwable t) {
                            RSocketRequester.this.errorConsumer.accept(t);
                            receiver.dispose();
                        }
                    });
                } else if (RSocketRequester.this.contains(streamId) && !receiver.isDisposed()) {
                    sendProcessor.onNext(RequestNFrameFlyweight.encode(RSocketRequester.this.allocator, streamId, n));
                }
            }
        }).doOnError(t -> {
            if (this.contains(streamId) && !receiver.isDisposed()) {
                sendProcessor.onNext(ErrorFrameFlyweight.encode(this.allocator, streamId, t));
            }
        }).doOnCancel(() -> {
            if (this.contains(streamId) && !receiver.isDisposed()) {
                sendProcessor.onNext(CancelFrameFlyweight.encode(this.allocator, streamId));
            }
        }).doFinally(s -> this.removeStreamReceiverAndSender(streamId));
    }

    private Mono<Void> handleMetadataPush(Payload payload) {
        Throwable err = this.terminationError;
        if (err != null) {
            payload.release();
            return Mono.error((Throwable)err);
        }
        return UnicastMonoEmpty.newInstance(() -> {
            ByteBuf metadataPushFrame = MetadataPushFrameFlyweight.encode(this.allocator, payload.sliceMetadata().retain());
            payload.release();
            this.sendProcessor.onNext(metadataPushFrame);
        });
    }

    private Throwable checkAvailable() {
        Throwable err = this.terminationError;
        if (err != null) {
            return err;
        }
        RequesterLeaseHandler lh = this.leaseHandler;
        if (!lh.useLease()) {
            return lh.leaseError();
        }
        return null;
    }

    private boolean contains(int streamId) {
        return this.receivers.containsKey(streamId);
    }

    private void handleIncomingFrames(ByteBuf frame) {
        try {
            int streamId = FrameHeaderFlyweight.streamId(frame);
            FrameType type = FrameHeaderFlyweight.frameType(frame);
            if (streamId == 0) {
                this.handleStreamZero(type, frame);
            } else {
                this.handleFrame(streamId, type, frame);
            }
            frame.release();
        }
        catch (Throwable t) {
            ReferenceCountUtil.safeRelease((Object)frame);
            throw reactor.core.Exceptions.propagate((Throwable)t);
        }
    }

    private void handleStreamZero(FrameType type, ByteBuf frame) {
        switch (type) {
            case ERROR: {
                this.tryTerminateOnZeroError(frame);
                break;
            }
            case LEASE: {
                this.leaseHandler.receive(frame);
                break;
            }
            case KEEPALIVE: {
                if (this.keepAliveFramesAcceptor == null) break;
                this.keepAliveFramesAcceptor.receive(frame);
                break;
            }
            default: {
                this.errorConsumer.accept(new IllegalStateException("Client received supported frame on stream 0: " + frame.toString()));
            }
        }
    }

    private void handleFrame(int streamId, FrameType type, ByteBuf frame) {
        Subscriber receiver = (Subscriber)this.receivers.get(streamId);
        if (receiver == null) {
            this.handleMissingResponseProcessor(streamId, type, frame);
        } else {
            switch (type) {
                case ERROR: {
                    receiver.onError((Throwable)Exceptions.from(streamId, frame));
                    this.receivers.remove(streamId);
                    break;
                }
                case NEXT_COMPLETE: {
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    receiver.onComplete();
                    break;
                }
                case CANCEL: {
                    RateLimitableRequestPublisher sender = (RateLimitableRequestPublisher)((Object)this.senders.remove(streamId));
                    if (sender == null) break;
                    sender.cancel();
                    break;
                }
                case NEXT: {
                    receiver.onNext(this.payloadDecoder.apply(frame));
                    break;
                }
                case REQUEST_N: {
                    RateLimitableRequestPublisher sender = (RateLimitableRequestPublisher)((Object)this.senders.get(streamId));
                    if (sender == null) break;
                    int n = RequestNFrameFlyweight.requestN(frame);
                    sender.request(n >= Integer.MAX_VALUE ? Long.MAX_VALUE : (long)n);
                    break;
                }
                case COMPLETE: {
                    receiver.onComplete();
                    this.receivers.remove(streamId);
                    break;
                }
                default: {
                    throw new IllegalStateException("Client received supported frame on stream " + streamId + ": " + frame.toString());
                }
            }
        }
    }

    private void handleMissingResponseProcessor(int streamId, FrameType type, ByteBuf frame) {
        if (!this.streamIdSupplier.isBeforeOrCurrent(streamId)) {
            if (type == FrameType.ERROR) {
                String errorMessage = ErrorFrameFlyweight.dataUtf8(frame);
                throw new IllegalStateException("Client received error for non-existent stream: " + streamId + " Message: " + errorMessage);
            }
            throw new IllegalStateException("Client received message for non-existent stream: " + streamId + ", frame type: " + (Object)((Object)type));
        }
    }

    private void tryTerminateOnKeepAlive(KeepAliveSupport.KeepAlive keepAlive) {
        this.tryTerminate(() -> new ConnectionErrorException(String.format("No keep-alive acks for %d ms", keepAlive.getTimeout().toMillis())));
    }

    private void tryTerminateOnConnectionClose() {
        this.tryTerminate(() -> CLOSED_CHANNEL_EXCEPTION);
    }

    private void tryTerminateOnZeroError(ByteBuf errorFrame) {
        this.tryTerminate(() -> Exceptions.from(0, errorFrame));
    }

    private void tryTerminate(Supplier<Exception> errorSupplier) {
        Exception e;
        if (this.terminationError == null && TERMINATION_ERROR.compareAndSet(this, null, e = errorSupplier.get())) {
            this.terminate(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminate(Exception e) {
        this.connection.dispose();
        this.leaseHandler.dispose();
        Object object = this.receivers;
        synchronized (object) {
            this.receivers.values().forEach(receiver -> {
                try {
                    receiver.onError((Throwable)e);
                }
                catch (Throwable t) {
                    this.errorConsumer.accept(t);
                }
            });
        }
        object = this.senders;
        synchronized (object) {
            this.senders.values().forEach(sender -> {
                try {
                    sender.cancel();
                }
                catch (Throwable t) {
                    this.errorConsumer.accept(t);
                }
            });
        }
        this.senders.clear();
        this.receivers.clear();
        this.sendProcessor.dispose();
        this.errorConsumer.accept(e);
    }

    private void removeStreamReceiver(int streamId) {
        if (this.terminationError == null) {
            this.receivers.remove(streamId);
        }
    }

    private void removeStreamReceiverAndSender(int streamId) {
        if (this.terminationError == null) {
            this.receivers.remove(streamId);
            RateLimitableRequestPublisher sender = (RateLimitableRequestPublisher)((Object)this.senders.remove(streamId));
            if (sender != null) {
                sender.cancel();
            }
        }
    }

    private void handleSendProcessorError(Throwable t) {
        this.connection.dispose();
    }

    static {
        CLOSED_CHANNEL_EXCEPTION.setStackTrace(new StackTraceElement[0]);
    }
}

