/*
 * Decompiled with CFR 0.152.
 */
package io.rsocket.util;

import io.netty.buffer.ByteBuf;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.MathUtil;
import io.netty.util.internal.StringUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.util.Arrays;

public class CharByteBufUtil {
    private static final byte WRITE_UTF_UNKNOWN = 63;

    private CharByteBufUtil() {
    }

    public static int utf8Bytes(char[] seq) {
        return CharByteBufUtil.utf8ByteCount(seq, 0, seq.length);
    }

    public static int utf8Bytes(char[] seq, int start, int end) {
        return CharByteBufUtil.utf8ByteCount(CharByteBufUtil.checkCharSequenceBounds(seq, start, end), start, end);
    }

    private static int utf8ByteCount(char[] seq, int start, int end) {
        int i;
        for (i = start; i < end && seq[i] < '\u0080'; ++i) {
        }
        return i < end ? i - start + CharByteBufUtil.utf8BytesNonAscii(seq, i, end) : i - start;
    }

    private static int utf8BytesNonAscii(char[] seq, int start, int end) {
        int encodedLength = 0;
        for (int i = start; i < end; ++i) {
            char c = seq[i];
            if (c < '\u0800') {
                encodedLength += (127 - c >>> 31) + 1;
                continue;
            }
            if (StringUtil.isSurrogate((char)c)) {
                char c2;
                if (!Character.isHighSurrogate(c)) {
                    ++encodedLength;
                    continue;
                }
                try {
                    c2 = seq[++i];
                }
                catch (IndexOutOfBoundsException ignored) {
                    ++encodedLength;
                    break;
                }
                if (!Character.isLowSurrogate(c2)) {
                    encodedLength += 2;
                    continue;
                }
                encodedLength += 4;
                continue;
            }
            encodedLength += 3;
        }
        return encodedLength;
    }

    private static char[] checkCharSequenceBounds(char[] seq, int start, int end) {
        if (MathUtil.isOutOfBounds((int)start, (int)(end - start), (int)seq.length)) {
            throw new IndexOutOfBoundsException("expected: 0 <= start(" + start + ") <= end (" + end + ") <= seq.length(" + seq.length + ')');
        }
        return seq;
    }

    public static int writeUtf8(ByteBuf buf, char[] seq) {
        return CharByteBufUtil.writeUtf8(buf, seq, 0, seq.length);
    }

    public static int writeUtf8(ByteBuf buf, char[] seq, int start, int end) {
        return CharByteBufUtil.writeUtf8(buf, buf.writerIndex(), CharByteBufUtil.checkCharSequenceBounds(seq, start, end), start, end);
    }

    static int writeUtf8(ByteBuf buffer, int writerIndex, char[] seq, int start, int end) {
        int oldWriterIndex = writerIndex;
        for (int i = start; i < end; ++i) {
            char c = seq[i];
            if (c < '\u0080') {
                buffer.setByte(writerIndex++, (int)((byte)c));
                continue;
            }
            if (c < '\u0800') {
                buffer.setByte(writerIndex++, (int)((byte)(0xC0 | c >> 6)));
                buffer.setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
                continue;
            }
            if (StringUtil.isSurrogate((char)c)) {
                if (!Character.isHighSurrogate(c)) {
                    buffer.setByte(writerIndex++, 63);
                    continue;
                }
                if (seq.length <= ++i) {
                    buffer.setByte(writerIndex++, 63);
                    break;
                }
                char c2 = seq[i];
                writerIndex = CharByteBufUtil.writeUtf8Surrogate(buffer, writerIndex, c, c2);
                continue;
            }
            buffer.setByte(writerIndex++, (int)((byte)(0xE0 | c >> 12)));
            buffer.setByte(writerIndex++, (int)((byte)(0x80 | c >> 6 & 0x3F)));
            buffer.setByte(writerIndex++, (int)((byte)(0x80 | c & 0x3F)));
        }
        buffer.writerIndex(writerIndex);
        return writerIndex - oldWriterIndex;
    }

    private static int writeUtf8Surrogate(ByteBuf buffer, int writerIndex, char c, char c2) {
        if (!Character.isLowSurrogate(c2)) {
            buffer.setByte(writerIndex++, 63);
            buffer.setByte(writerIndex++, Character.isHighSurrogate(c2) ? 63 : (int)c2);
            return writerIndex;
        }
        int codePoint = Character.toCodePoint(c, c2);
        buffer.setByte(writerIndex++, (int)((byte)(0xF0 | codePoint >> 18)));
        buffer.setByte(writerIndex++, (int)((byte)(0x80 | codePoint >> 12 & 0x3F)));
        buffer.setByte(writerIndex++, (int)((byte)(0x80 | codePoint >> 6 & 0x3F)));
        buffer.setByte(writerIndex++, (int)((byte)(0x80 | codePoint & 0x3F)));
        return writerIndex;
    }

    public static char[] readUtf8(ByteBuf byteBuf, int length) {
        CharsetDecoder charsetDecoder = CharsetUtil.UTF_8.newDecoder();
        int en = (int)((double)length * (double)charsetDecoder.maxCharsPerByte());
        char[] ca = new char[en];
        CharBuffer charBuffer = CharBuffer.wrap(ca);
        ByteBuffer byteBuffer = byteBuf.internalNioBuffer(byteBuf.readerIndex(), length);
        byteBuffer.mark();
        try {
            CoderResult cr = charsetDecoder.decode(byteBuffer, charBuffer, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = charsetDecoder.flush(charBuffer)).isUnderflow()) {
                cr.throwException();
            }
            byteBuffer.reset();
            byteBuf.skipBytes(length);
            return CharByteBufUtil.safeTrim(charBuffer.array(), charBuffer.position());
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException("unable to decode char array from the given buffer", x);
        }
    }

    private static char[] safeTrim(char[] ca, int len) {
        if (len == ca.length) {
            return ca;
        }
        return Arrays.copyOf(ca, len);
    }
}

